<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\CustomerCategoryGroupSpending18M
 * @property int $customer_id
 * @property int $productcategorygroup_id
 * @property float $spending
 * @property Customer $customer
 * @property ProductCategoryGroup $productCategoryGroup
 */
class CustomerCategoryGroupSpending18M extends WebModel {
	protected $table = 'CustomerCategoryGroupSpending12M';
	protected $fillable = [];
	protected $appends = ['product_category_group_name'];

	public function customer(): BelongsTo {
	    return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function productCategoryGroup(): BelongsTo {
	    return $this->belongsTo(ProductCategoryGroup::class, 'productcategorygroup_id');
    }

    public function getProductCategoryGroupNameAttribute() {
	    return $this->productCategoryGroup->product_category_group;
    }
}
