<?php

namespace Hilco\Models;

use Auth;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Lang;
use Storage;
use Image as Image2;

/**
 * Hilco\Models\Product
 *
 * @property string unit_of_measure
 * @property mixed $id
 * @property string $part_no
 * @property string $part_desc
 * @property string $part_upc
 * @property string $upc_w_check
 * @property string $sls_uom
 * @property string $weight_lbs
 * @property string $vol_ci
 * @property boolean $private_lbl
 * @property string $cat_item
 * @property boolean $web_part
 * @property string $incept_dt
 * @property string $pf_prod_mgr
 * @property string $prod_fam_no
 * @property string $product_family
 * @property string $pf_group
 * @property string $fin_rpt_sum
 * @property string $fin_rpt_sub
 * @property string $product_category
 * @property string $product_category_grp
 * @property string $product_category_summ
 * @property string $web_part_desc
 * @property string $web_part_family
 * @property float $list_price
 * @property string $price_group
 * @property string $prod_cat
 * @property string $prod_cat_grp
 * @property string $prod_cat_summ
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Hilco\Models\WebPart $details
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\ProductAttributeValues[] $attributes
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\PriceList[] $prices
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Cart[] $cart_items
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\InventoryItem[] $inventory_items
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePartNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePartDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePartUpc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereUpcWCheck($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereSlsUom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWeightLbs($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereVolCi($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePrivateLbl($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereCatItem($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWebPart($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereInceptDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePfProdMgr($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdFamNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductFamily($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePfGroup($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereFinRptSum($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereFinRptSub($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductCategory($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductCategoryGrp($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductCategorySumm($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWebPartDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWebFamily($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereListPrice($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePriceGroup($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdCat($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdCatGrp($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdCatSumm($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $product_family_no
 * @property mixed $productfamily_id
 * @property string $rx_dose_form
 * @property string $rx_ndc
 * @property float $rx_packsize
 * @property string $rx_strength
 * @property string $vat_code
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductFamilyNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductfamilyId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxDoseForm($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxNdc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxPacksize($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxStrength($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereVatCode($value)
 * @property string $pointman_web_part_desc
 * @property string $pointman_web_part_family
 * @property string $date_uploaded
 * @property-read mixed $web_part_name
 * @property-read mixed $name
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePointmanWebPartDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePointmanWebPartFamily($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part distinctProductManagers()
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part managedBy($product_manager)
 */
class Part extends WebModel
{
	protected $table = 'Parts';
//	protected $appends = ['web_part_name', 'web_part_family'];
	protected $with = ['partDescriptionTranslations'];
	protected $guarded = ['id'];
	protected $getterMutators = [
//		'id' => 'bin2hex',
		'productfamily_id' => 'bin2hex',
	];
	protected $setterMutators = [
		'productfamily_id' => 'hex2bin',
	];

    const IN_STOCK = 'inStock';
    const OUT_OF_STOCK = 'outOfStock';
    const DELAYED = 'delayed';
    const UNKNOWN = 'unknown';

	public function webPart() {
		return $this->hasOne(WebPart::class, 'part_number', 'part_no');
	}

    /**
     * @return BelongsToMany
     */
	public function webSilos() {
	    return $this->belongsToMany(WebSilo::class, 'WebSilo_Part', 'part_id', 'websilo_id')->withPivot(['require_approval']);
    }

	public function VATTax(){
		return  $this->belongsTo(VATTax::class, 'vat_code', 'vat_code')
				->where(function($query){
					$query->where(function($query){
						return $query->where('effective_date','<=', date('Y-m-d',time()))
							->where('expiration_date','>=', date('Y-m-d',time()));
					})
						->orWhere('expiration_date', '0000-00-00');
				});
	}
	public function details() {
		return $this->webPart();
	}

	public function getWebPartNameAttribute() {
		return is_null($this->details) ? null : $this->details->web_part_name;
	}

	public function getNameAttribute() {
		return is_null($this->web_part_name) ? $this->part_desc : $this->web_part_name;
	}

	public function getWebFamilyAttribute() {
		return $this->details->webFamily;
	}

//	public function attributes()
//	{
//		return $this->belongsToMany(ProductAttributeValues::class, 'Part_PartAttributeValue', 'part_id', 'partattributevalue_id');
//		return $this->belongsToMany(ProductAttributeValues::class, 'Part_PartAttributeValue', 'part_id', 'partattributevalue_id');
//	}

    public function scopeVisibleToActiveUser(Builder $query, $activeWebSilo = false, $activeCountry = false, $activePlant = false) {
        if ($activeWebSilo === false) $activeWebSilo = b2b()->activeWebSilo();
        if ($activeCountry === false) $activeCountry = b2b()->activeCountry();

        if ($activeWebSilo->limit_parts) {
            $query->whereHas('webSilos', function ($query) use ($activeWebSilo) {
                return $query->where('websilo_id', '=', $activeWebSilo->id);
            });
        }

        if (!$activeWebSilo->allow_private_label) {
            $query->where('private_lbl', '0');
        }

        $query->where(function ($where) {
            $where
                ->has('genericPrices')
                ->orHas('customerPrices')
            ;
        });

        $query->where('web_visible', 1);
    }

    public function scopeWebVisible(Builder $query) {
        $webSilo = b2b()->activeWebSilo();
        $country = b2b()->activeCountry();

	    if ($webSilo->limit_parts) {
            $query->whereHas('webSilos', function ($query) use ($webSilo) {
	            return $query->where('websilo_id', '=', $webSilo->id);
            });
        }

        if (!$webSilo->allow_private_label) {
	        $query->where('private_lbl', '0');
        }

        $query->where('web_visible', 1);
//	    if ($webSilo->id == 4) {
//	        $query->whereHas('webSilos', function ($query) {
//	            return $query->where('websilo_id', '=', '4');
//            });
//        } else {
//	        $query->where('private_lbl', '0');
//        }


//        if (b2b()->activeCountry() != 'US') {
//	        $query->isNotRX();
//        }

        $query->whereHas('inventoryItems', function ($query) use ($webSilo, $country) {
//            if ($country == 'US') $query->inPlant('PLAINVILLE');
//            $query->inPlant(array_get(b2b()->activePlant(), 'plant', 'PLAINVILLE'));

            return $query->inSilo($webSilo->id);
        })
        ->where(function ($where) {
            $where
                ->has('genericPrices')
                ->orHas('customerPrices')
            ;
        })
        ;
    }

    public function partDetailDescriptions() {
	    return $this->hasMany(PartDetailDescription::class, 'part_id', 'id');
    }

    public function getPartDetailDescription($language = false) {
	    if ($language === false) {
	        $activeLanguage = b2b()->activeLanguage();
	        switch ($activeLanguage) {
                case 'en':
                    $language = 'ENU';
                    break;
                default:
                    $language = '';
            }
        }
	    $description = [];
	    $this
            ->partDetailDescriptions
            ->where('language', $language)
            ->sortBy('line_number')
            ->each (function ($line) use (&$description) {
                $description[] = $line->description;
            })
        ;
	    return $description;
    }

    public function getPartDetailDescriptionAttribute() {
	    return $this->getPartDetailDescription();
    }

    public function partDescriptionTranslations() {
        return $this->hasMany(PartDescriptionTranslation::class, 'part_id', 'id');
    }

    public function getPartDescriptionTranslation($language = false) {
        if ($language === false) {
            $activeLanguage = b2b()->activeLanguage();
            switch ($activeLanguage) {
                case 'en':
                    $language = 'ENU';
                    break;
                default:
                    $language = '';
            }
        }
        $description = [];
        $this
            ->partDescriptionTranslations
            ->where('language', $language)
            ->sortBy('line_number')
            ->each (function ($line) use (&$description) {
                $description[] = $line->description;
            })
        ;
        return $description;
    }

    public function getPartDescriptionTranslationAttribute() {
        return $this->getPartDescriptionTranslation();
    }

    public function customerPrices($customer = null) {
	    if($customer == null){
            $customer = b2b()->activeCustomer();
        }
	    $customerNumber = array_get($customer, 'cust_no');
	    $customerPriceGroup = array_get($customer, 'default_price_list');
        return $this
            ->hasMany(PriceListCustomer::class, 'part_id', 'id')
            ->active()
            ->forCustomerOrGroup($customerNumber, $customerPriceGroup)
            ->orderBy('start_date', 'DESC')
        ;
    }

    public function campaignPrices() {
        $customer = b2b()->activeCustomer();
        $campaignPriceLists = array_get($customer, 'campaignPriceLists', collect());
        $lists = $campaignPriceLists->pluck('price_list')->unique();
        return $this
            ->hasMany(PriceListGeneric::class, 'part_id', 'id')
            ->active()
            ->inLists($lists)
            ->orderBy('unit_price', 'ASC')
        ;
    }

    public function genericPrices() {
        $customerPriceList = b2b()->activePriceList();

        return $this
            ->hasMany(PriceListGeneric::class, 'part_id', 'id')
            ->active()
            ->inLists([$customerPriceList])
            ->orderBy('start_date', 'DESC')
        ;
    }

//    public function getPricesAttribute() {
//	    $customerPrices = $this->customerPrices;
//	    $genericPrices = $this->genericPrices;
//
//	    $prices = new Collection;
//
//	    foreach ($customerPrices as $price) {
//	        $quantityLevel = array_get($price, 'quantity_level');
//	        $unitPrice = array_get($price, 'unit_price');
//
//	        $existingPrice = $prices->where('quantity_level', $quantityLevel)->first();
//	        if (is_null($existingPrice) || $unitPrice < array_get($existingPrice, 'unit_price')) {
//	            $prices->push([
//                    'quantity_level' => $quantityLevel,
//                    'unit_price' => $unitPrice,
//                ]);
//            }
//        }
//
//        foreach ($genericPrices as $price) {
//            $quantityLevel = array_get($price, 'quantity_level');
//            $unitPrice = array_get($price, 'unit_price');
//
//            $existingPrice = $prices->where('quantity_level', $quantityLevel)->first();
//            if (is_null($existingPrice) || $unitPrice < array_get($existingPrice, 'unit_price')) {
//                $prices->push([
//                    'quantity_level' => $quantityLevel,
//                    'unit_price' => $unitPrice,
//                ]);
//            }
//        }
//
//        return $prices;
//    }

//	public function getPricesArrayAttribute() {
//	    $prices = [];
//        $this->customerPrices->each(function ($item) use (&$prices) {
//            $prices[$item->sales_type . '-' . $item->sales_code][$item->quantity_level] = collect($item->toArray())->sortByDesc('quantity_level');
//        });
//        if (array_has($prices, b2b()->activePriceList())) return $prices[b2b()->activePriceList()];
//        return array_get($prices, b2b()->activeWebSilo()->priceList);
//    }

    public function getIsDiscounted($quantity = 1) {
        $array = $this->getPriceLevelInformation();
        $isDiscounted = false;
        foreach ($array as $quantityLevel => $priceLevel) {
            if ($quantity >= $quantityLevel) {
                $isDiscounted = array_get($priceLevel, 'isDiscounted', false);
            }
        }

        return $isDiscounted;
    }

    public function getCustomerPrice($quantity = 1,$customer = null) {
	    $array = $this->getPriceLevelInformation($customer);
	    $price = PHP_INT_MAX;
        $minQuantity = PHP_INT_MAX;
	    foreach ($array as $quantityLevel => $priceLevel) {
            $minQuantity = min($minQuantity, $quantityLevel);
	        if ($quantity >= $quantityLevel) {
	            $price = min($price, array_get($priceLevel, 'customerPrice', array_get($priceLevel, 'genericPrice', 0)));
            }
        }

        if ($price == PHP_INT_MAX && $minQuantity != PHP_INT_MAX && $minQuantity > $quantity) {
            $price = array_get($array[$minQuantity], 'customerPrice', array_get($array[$minQuantity], 'genericPrice', 0));
        }

        if ($price == PHP_INT_MAX) {
	        $price = 0;
        }

        return $price;
    }

    public function getPricesArrayAttribute() {
	    $pricesArray = [];
	    $quantityLevels = [];
	    foreach ($this->genericPrices as $genericPrice) {
	        $level = array_get($genericPrice, 'quantity_level', 1);
	        $quantityLevels[$level] = $level;
        }
        foreach ($this->customerPrices as $customerPrice) {
            $level = array_get($customerPrice, 'quantity_level', 1);
            $quantityLevels[$level] = $level;
        }

        foreach ($quantityLevels as $quantityLevel) {
	        $pricesArray[$quantityLevel]['generic'] = $this->getGenericPrice($quantityLevel);
	        $pricesArray[$quantityLevel]['customer'] = $this->getCustomerPrice($quantityLevel);
        }

        return $pricesArray;

//	    foreach ($this->genericPrices->sortBy('quantity_level') as $price) {
//	        $quantityLevel = array_get($price, 'quantity_level');
//	        $unitPrice = array_get($price, 'unit_price');
//	        $pricesArray[$quantityLevel]['generic'] = $unitPrice;
//        }
//
//        if ($customerDiscountPercent > 0) {
//            foreach ($pricesArray as $quantityLevel => $price) {
//                $model = $this->getGenericPriceLogic($quantityLevel);
//                if (array_get($model, 'allow_line_disc', 0)) {
//                    $pricesArray[$quantityLevel]['customer'] = $unitPrice - round($unitPrice * $customerDiscountPercent, 2);
//                }
//            }
//        }
//
//        foreach ($this->customerPrices->sortBy('quantity_level') as $price) {
//            $quantityLevel = array_get($price, 'quantity_level');
//            $unitPrice = array_get($price, 'unit_price');
//            $pricesArray[$quantityLevel]['customer'] = $unitPrice - round($unitPrice * $customerDiscountPercent, 2);
//        }
//
//        return $pricesArray;
    }

    public function getGenericPrice($quantity = 1) {
	    $genericPrice = 0;
	    foreach ($this->genericPrices->sortByDesc('quantity_level') as $price) {
	        if ($quantity >= array_get($price, 'quantity_level')) {
	            $genericPrice = array_get($price, 'unit_price');
	            break;
            }
        }

        return $genericPrice;
    }

    public function getGenericPriceLogic($quantity = 1) {
        foreach ($this->genericPrices->sortByDesc('quantity_level') as $price) {
            if ($quantity >= array_get($price, 'quantity_level')) {
                return $price;
            }
        }

        return false;
    }

    public function getCustomerPriceLogic($quantity = 1) {
        foreach ($this->customerPrices->sortByDesc('quantity_level') as $price) {
            if ($quantity >= array_get($price, 'quantity_level')) {
                return $price;
            }
        }

        return false;
    }


    public function itemDiscounts() {
	    return $this
            ->hasMany(ItemDiscount::class, 'code', 'part_no')
            ->itemDiscounts()
        ;
    }

    public function itemGroupDiscounts() {
        return $this
            ->hasMany(ItemDiscount::class, 'code', 'product_group_code')
            ->groupDiscounts()
        ;
    }

    public function getDiscountPercent($quantity = 1, Customer $customer = null) {
	    if (is_null($customer)) $customer = b2b()->activeCustomer();

	    if (!$customer) return 0;
	    $part = $this;

	    $customerDiscountGroups = $customer->customerDiscountGroups->pluck('discount_group_code');
	    $possibleDiscounts = [];

	    foreach ($this->itemDiscounts as $itemDiscount) {
	        if ($itemDiscount->sales_type == 'Customer Disc. Group'
                && (
                    $customerDiscountGroups->contains($itemDiscount->sales_code)
                    || $itemDiscount->sales_code == $customer->discount_group
                )
                && $itemDiscount->quantity_level >= $quantity
            ) {
	            $possibleDiscounts[] = $itemDiscount;
            }
        }

        foreach ($this->itemGroupDiscounts as $itemDiscount) {
            if ($itemDiscount->sales_type == 'Customer Disc. Group'
                && (
                    $customerDiscountGroups->contains($itemDiscount->sales_code)
                    || $itemDiscount->sales_code == $customer->discount_group
                )
                && $itemDiscount->quantity_level >= $quantity
            ) {
                $possibleDiscounts[] = $itemDiscount;
            }
        }

        $bestDiscount = 0;
	    foreach ($possibleDiscounts as $possibleDiscount) {
	        $discount = array_get($possibleDiscount, 'line_discount_perc');
	        if ($discount > $bestDiscount) $bestDiscount = $discount;
        }

        return $bestDiscount;

//	    $customerDiscounts = $customer->discounts->filter(function ($discount) use ($part) {
//	        return (
//                ($discount->productfamily_id && $discount->productfamily_id == $part->productfamily_id)
//                || ($discount->part_id && $discount->part_id == $part->id)
//            );
//        });
//
//	    $customerDiscountAmount = 0;
//	    foreach ($customerDiscounts as $customerDiscount) {
//	        $customerDiscountAmount += $customerDiscount->disc_val;
//        }
//
//        $rewardsDiscountAmount = rewards()->discountForPart($this, $customer);
//
//	    return ($rewardsDiscountAmount > $customerDiscountAmount) ? $rewardsDiscountAmount : $customerDiscountAmount;
    }

    public function getApplicableDiscounts(Customer $customer = null) {
	    return [];

        if (is_null($customer)) $customer = b2b()->activeCustomer();
        $part = $this;
        $discounts = [];

        $customerDiscounts = $customer->discounts->filter(function ($discount) use ($part) {
            return (
                ($discount->productfamily_id && $discount->productfamily_id == $part->productfamily_id)
                || ($discount->part_id && $discount->part_id == $part->id)
            );
        });

        $customerDiscountTotal = 0;
        foreach ($customerDiscounts as $customerDiscount) {
            $discounts[] = [
                'type' => 'customer',
                'percent' => $customerDiscount->disc_val,
            ];
            $customerDiscountTotal += $customerDiscount->disc_val;
        }
        $rewardsDiscountAmount = 0;
        if(rewards()->isEligible($customer, false)) {
            $rewardsDiscountAmount = rewards()->discountForPart($this, $customer);
        }

        if ($rewardsDiscountAmount > $customerDiscountTotal) {
            $discounts[] = [
                'type' => 'rewards',
                'percent' => $rewardsDiscountAmount,
            ];
        }

        return $discounts;
    }

    public function getCustomerDiscount($quantity = 1, Customer $customer = null) {
	    return $this->getDiscountPercent($quantity, $customer);
    }


//    public function getCustomerDiscount() {
//        $productFamilyId = $this->productfamily_id;
//        $partId = $this->id;
//        $customerDiscounts = b2b()->activeCustomer()->discounts->filter(function ($item) use ($productFamilyId, $partId) {
//            return (
//                ($item->productfamily_id && $item->productfamily_id == $productFamilyId)
//                || ($item->part_id && $item->part_id == $partId)
//            );
//        });
//
//        $customerDiscountAmount = 0;
//        foreach ($customerDiscounts as $customerDiscount) {
//            $customerDiscountAmount += $customerDiscount->disc_val;
//        }
//        $rewardsDiscountAmount = rewards()->discountForPart($this);
//
//        if ($rewardsDiscountAmount > 0 && $rewardsDiscountAmount > $customerDiscountAmount) return $rewardsDiscountAmount;
//
//        return $customerDiscountAmount;
//    }

    public function getCustomerPriceAttribute() {
        return $this->getCustomerPrice();
    }

    public function getGenericPriceAttribute() {
	    return $this->getGenericPrice();
    }

//	public function cart_items()
//	{
//		return $this->hasMany(Cart::class, 'product_id');
//	}

    public function inventoryItem() {
	    return $this->hasOne(InventoryItem::class, 'part_id', 'id');
    }

	public function inventoryItems() {
        return $this->hasMany(InventoryItem::class, 'part_id', 'id');
	}

//	public function inventory_items()
//	{
//		return $this->hasMany(InventoryItem::class, 'part_id', 'id');
//	}

	public function plainvilleInventory()
	{
		return $this->hasMany(InventoryItem::class, 'part_id')->where('plant','PLAINVILLE');
	}

//	public function getImageLink($width = null, $height = null)
//	{
//		$name = ($width ? $width : 'a') . 'x' . ($height ? $height : 'a');
//		$extension_arr = array('.jpg', '.png');
//		$src =  url('img/logo_hilco.png'); //TODO: change to "NoImage" picture
//		if($this->part_no) {
//			foreach ( $extension_arr as $extension ) {
//				if(Storage::disk('product')->exists($this->part_no . $extension)){
//					if ((Image2::make(public_path('img/products/' . $this->part_no . $extension))->width() > $width || Image2::make(public_path('img/products/' . $this->part_no . $extension))->height() > $height)
//					    && (!Storage::disk('product')->exists($this->part_no . '_' . $name . $extension))) {
//						Image2::make(public_path('img/products/' . $this->part_no . $extension))->fit($width, $height)->save(public_path('img/products/' . $this->part_no . '_' . $name . $extension));
//						$src = url('img/products/'.  $this->part_no . '_' . $name . $extension);
//					} else {
//						$src = url('img/products/'.  $this->part_no . $extension);
//					}
//					break;
//				}
//			}
//		}
//
//		return $src;
//	}

	public function productFamily()	{
		return $this->belongsTo(ProductFamilies::class, 'productfamily_id', 'id');
	}

	public static function getPartsBySummary($id)
	{
		$category_arr = ProductCategory::whereHas('categoryGroup', function($categoryGroup) use ($id){
							$categoryGroup->whereHas('categorySummary', function($categorySummary) use ($id) {
								$categorySummary->where('id', '=', ($id));
							});
						})->get();
		if ($category_arr) {
			$items = array();
			foreach ($category_arr as $category) {
				$family = ProductCategory::getProductFamilies($category->id)->toArray();
				$collection = Part::where('web_part', 1)->whereIn('productfamily_id', $family)->get();
				if (!$collection->isEmpty() && $collection->count() >= 2) {
					$merge_arr = $collection->random( 2 )->toArray();
					$items = array_merge($items, $merge_arr);
				}
			}
		}
		return $items;
	}

	/**
	 * @param \Illuminate\Database\Query\Builder $query
	 * @return mixed
     */
	public function scopeDistinctProductManagers($query) {
		return $query->distinct()->select('pf_prod_mgr');
	}

	public function scopeManagedBy($query, $product_manager) {
		return $query->where('pf_prod_mgr', $product_manager);
	}

	public function scopeWebParts($query) {
		return $query->where('web_part', 1);
	}

	public static $rxProductFamilyNumbers = [
        'W01-0001',
        'W01-1500',
        'W02-0002',
        'W02-0030',
        'W02-0050',
        'W02-0053',
        'W02-0054',
        'W02-0055',
    ];

    public function getIsRXAttribute() {
        return (in_array($this->product_family_no, self::$rxProductFamilyNumbers));
    }
	
	public function scopeIsNotRX(Builder $query){
	    return $query->whereNotIn('product_family_no', self::$rxProductFamilyNumbers);
//		return $query->where(function(Builder $query){
//			return $query->where('rx_ndc','=',"")->orWhere('rx_ndc','=',"N/A");
//		})->whereHas('webPart', function (Builder $webPartQuery) {
//		    return $webPartQuery->whereHas('webFamily', function (Builder $webFamilyQuery) {
//		        return $webFamilyQuery->whereHas('webCollections', function (Builder $webCollectionsQuery) {
//		            return $webCollectionsQuery->whereHas('webCategories', function (Builder $webCategoriesQuery) {
//		                return $webCategoriesQuery->whereHas('webGroups', function (Builder $webGroupsQuery) {
//		                    return $webGroupsQuery->where('slug', '!=', 'pharmaceuticals');
//                        });
//                    });
//                });
//            });
//        });
	}

	public function inStockForPlant($plant) {
	    $inStock = false;

	    foreach ($this->inventoryItems as $inventoryItem) {
	        if ($inventoryItem->plant == $plant && $inventoryItem->in_stock) $inStock = true;
        }

        return $inStock;
    }

    public function getInStockAttribute() {
        $inStock = false;
        foreach ($this->inventoryItems as $inventoryItem) {
            if ($inventoryItem->in_stock) $inStock = true;
        }
        return $inStock;
    }

	public function getStockStatusAttribute() {
	    return $this->in_stock ? self::IN_STOCK : self::OUT_OF_STOCK;
    }

    public function scopeWebSiloApproved(Builder $query, $webSiloId = false) {
	    if ($webSiloId === false) $webSiloId = b2b()->activeWebSilo()->id;
	    return $query->whereHas('webSilos', function ($webSiloQuery) use ($webSiloId) {
	        $webSiloQuery->where('require_approval', '=', '0')->where('websilo_id', '=', $webSiloId);
        });
    }

    public function getRequireApprovalAttribute() {
	    $partSilo = $this->webSilos->whereLoose('id', b2b()->activeWebSilo()->id)->first();
	    if (!isset($partSilo) || $partSilo->limit_parts == 0) {
	        return false;
        } else {
            return array_get($partSilo, 'pivot.require_approval', false);
        }
    }
    
    /*NEW GERMANY FUNCTIONS START HERE*****************/

    public function getPriceInformation() {
        $prices = [];
        foreach ($this->genericPrices as $price) {
            $prices[] = [
               'quantity_level' => max(1, array_get($price, 'quantity_level', 1)),
               'type' => 'generic',
               'unit_price' => array_get($price, 'unit_price', 0),
               'allow_line_disc' => array_get($price, 'allow_line_disc'),
               'allow_invoice_disc' => array_get($price, 'allow_invoice_disc'),
               'allow_condition_disc' => array_get($price, 'allow_line_disc'),
               'allow_productgroup_disc' => array_get($price, 'allow_productgroup_disc'),
            ];
        }

        foreach ($this->customerPrices as $price) {
            $prices[] = [
                'quantity_level' => max(1, array_get($price, 'quantity_level', 1)),
                'type' => 'customer',
                'unit_price' => array_get($price, 'unit_price', 0),
                'allow_line_disc' => array_get($price, 'allow_line_disc'),
                'allow_invoice_disc' => array_get($price, 'allow_invoice_disc'),
                'allow_condition_disc' => array_get($price, 'allow_line_disc'),
                'allow_productgroup_disc' => array_get($price, 'allow_productgroup_disc'),
            ];
        }

        return $prices;
    }
    
    public function getDiscountInformation() {
        $discounts = [];

        foreach ($this->itemDiscounts as $discount) {
            $discounts[] = [
                'type' => 'item',
                'sales_type' => array_get($discount, 'sales_type'),
                'sales_code' => array_get($discount, 'sales_code'),
                'quantity_level' => max(1, array_get($discount, 'quantity_level')),
                'line_discount_perc' => array_get($discount, 'line_discount_perc'),
            ];
        }

        foreach ($this->itemGroupDiscounts as $discount) {
            $discounts[] = [
                'type' => 'group',
                'sales_code' => array_get($discount, 'sales_code'),
                'sales_type' => array_get($discount, 'sales_type'),
                'quantity_level' => max(1, array_get($discount, 'quantity_level')),
                'line_discount_perc' => array_get($discount, 'line_discount_perc'),
            ];
        }

        return $discounts;
    }

    public function getPriceLevelInformationForQuantity($quantity) {
        $level = false;
        $array = $this->getPriceLevelInformation();
        foreach ($array as $quantityLevel => $priceLevel) {
            if ($quantity >= $quantityLevel) {
                $level = $priceLevel;
            }
        }
        return $level;
    }

    public function getPriceLevelInformation($customer = null) {
//        if ($this->part_no = '749442') {
//            $breakpoint = 1;
//        }
        $priceLevels = [];
        foreach ($this->genericPrices as $genericPrice) {
//            if ($genericPrice->part_no != $this->part_no) continue;
            $level = max(1, $genericPrice->quantity_level);
            $priceLevels[$level]['genericPrice'] = $genericPrice->unit_price;
            $priceLevels[$level]['allowLineDiscounts'] = $genericPrice->allow_line_disc;
            $priceLevels[$level]['netItem'] = $genericPrice->allow_line_disc == 0 && $genericPrice->allow_invoice_disc == 0 && $genericPrice->allow_productgroup_disc == 0;
        }

        foreach ($this->customerPrices($customer) as $customerPrice) {
            $level = max(1, $customerPrice->quantity_level);
            if (isset($priceLevels[$level])) {
                $genericPrice = array_get($priceLevels, "$level.genericPrice");
//                $priceLevels[$level]['customerPrice'] = $customerPrice->unit_price;
//                $priceLevels[$level]['customerPriceDiscount'] = round((100 - ($customerPrice->unit_price / $genericPrice * 100)), 2);
                $priceLevels[$level]['genericPrice'] = $customerPrice->unit_price;
                $priceLevels[$level]['allowLineDiscounts'] = $customerPrice->allow_line_disc;
                $priceLevels[$level]['netItem'] = $customerPrice->allow_line_disc == 0 && $customerPrice->allow_invoice_disc == 0 && $customerPrice->allow_productgroup_disc == 0;
            }
        }

        foreach ($this->campaignPrices as $campaignPrice) {
            $level = max(1, $campaignPrice->quantity_level);
            if (isset($priceLevels[$level])) {
                $genericPrice = array_get($priceLevels, "$level.genericPrice");
                $customerPrice = array_get($priceLevels, "$level.customerPrice", $genericPrice);
                if ($campaignPrice->unit_price < min($genericPrice, $customerPrice)) {
                    // 2018-06-14: We are switching which lines are commented out in response to a request from Pamela.
                    // Doing show displays campaign prices as being a discount over the generic price.
                    $priceLevels[$level]['customerPrice'] = $campaignPrice->unit_price;
                    $priceLevels[$level]['customerPriceDiscount'] = round((100 - ($campaignPrice->unit_price / $genericPrice * 100)), 2);
//                    $priceLevels[$level]['genericPrice'] = $campaignPrice->unit_price;
                    // End swapped comments.
                    $priceLevels[$level]['allowLineDiscounts'] = $campaignPrice->allow_line_disc;
                    $priceLevels[$level]['netItem'] = false;
                }
            }
        }

        $activeCustomer = b2b()->activeCustomer();
        if ($activeCustomer) {
            $groupCodes = $activeCustomer->customerDiscountGroups->pluck('discount_group_code')->put($activeCustomer->discount_group, $activeCustomer->discount_group);
        } else {
            $groupCodes = collect();
        }

        $listOfPriceListLevels = array_keys($priceLevels);
        foreach ([$this->itemDiscounts, $this->itemGroupDiscounts] as $discountsList) {
            foreach ($discountsList as $itemDiscount) {
                $level = max(1, $itemDiscount->quantity_level);

                if ($itemDiscount->sales_type == 'Customer Disc. Group' && $groupCodes->contains($itemDiscount->sales_code)) $validDiscount = true;
                else if ($itemDiscount->sales_type == 'Customer' && $itemDiscount->sales_code == $activeCustomer->cust_no) $validDiscount = true;
                else if ($itemDiscount->sales_type == 'All Customers') $validDiscount = true;
                else $validDiscount = false;

                $priceListLevel = 0;
                foreach ($listOfPriceListLevels as $key) {
                    if ($key <= $level) {
                        $priceListLevel = $key;
                    } else {
                        break;
                    }
                }

                $allowDiscounts = array_get($priceLevels, "$priceListLevel.allowLineDiscounts", false);

                if ($allowDiscounts && $validDiscount) {
                    $existingDiscount = array_get($priceLevels, "$level.discount", 0);
                    $customerPriceDiscount = array_get($priceLevels, "$level.customerPriceDiscount", 0);
//                    if ($customerPriceDiscount > max($existingDiscount, $itemDiscount->line_discount_perc)) {
//                        $priceLevels[$level]['isDiscounted'] = false;
//                        $priceLevels[$level]['isCustomerPrice'] = true;
//                    } else {
                        $priceLevels[$level]['discount'] = max($existingDiscount, $itemDiscount->line_discount_perc);
                        $priceLevels[$level]['discounts'][] = $itemDiscount;
                        $priceLevels[$level]['isDiscounted'] = true;
                        $priceLevels[$level]['isCustomerPrice'] = false;
//                    }
                }
            }
        }

        $previousLevel = [];
        foreach($priceLevels as $index=>$priceLevel) {
            if (!isset($priceLevel['genericPrice'])) {
                $priceLevel['genericPrice'] = array_get($previousLevel, 'genericPrice', 0);
            }

            if (!isset($priceLevel['allowLineDiscounts'])) {
                $priceLevel['allowLineDiscounts'] = array_get($previousLevel, 'allowLineDiscounts', 0);
            }

            if (!isset($priceLevel['netItem'])) {
                $priceLevel['netItem'] = array_get($previousLevel, 'netItem', false);
            }

            if (array_get($priceLevel, 'discount', 0) && array_get($priceLevel, 'allowLineDiscounts', 0)) {
                $customerPrice = array_get($priceLevel, 'customerPrice', array_get($priceLevel, 'genericPrice', 0));
                $priceLevel['customerPrice'] = round($customerPrice - round(($customerPrice * ($priceLevel['discount'] / 100)), 2), 2);
            }

            $priceLevels[$index] = $priceLevel;
            $previousLevel = $priceLevel;
        }

        ksort($priceLevels);
        return $priceLevels;
    }

    public function getPackingUnitAttribute() {
        $pimTranslationKey = 'uom.'.$this->pim;
        $translatedPIM = Lang::has($pimTranslationKey) ? trans($pimTranslationKey) : $this->pim;
        return $this->pie . ' ' . $translatedPIM;
    }

    public function partSubstitutes() {
        return $this->belongsToMany(Part::class, 'PartSubstitutions', 'part_id', 'substitute_part_id'   );
    }

    public function substituteForParts() {
        return $this->belongsToMany(Part::class, 'PartSubstitutions','substitute_part_id', 'part_id');
    }

    public function getPartSubstituteAttribute() {
        return $this->partSubstitutes->first();
    }

    public function getSubstituteForPartAttribute() {
        return $this->substituteForParts->first();
    }
}

