<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\InventoryItem
 *
 * @property mixed $id
 * @property string $plant
 * @property mixed $plant_id
 * @property string $part_no
 * @property mixed $part_id
 * @property string $part_status
 * @property string $part_src
 * @property string $part_type
 * @property boolean $part_taxable
 * @property boolean $kit_flag
 * @property boolean $on_bom
 * @property boolean $has_bom
 * @property integer $mfg_atp
 * @property float $first_avail_qty
 * @property string $first_avail_dt
 * @property float $max_available_qty
 * @property string $max_avail_dt
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePlant($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePlantId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartStat($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartSrc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartTaxable($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereKitFlag($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereOnBom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereHasBom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereMfgAtp($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereFirstAvailQty($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereFirstAvailDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereMaxAvailQty($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereMaxAvailDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDeletedAt($value)
 * @mixin \Eloquent
 * @property integer $lot_control
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereLotControl($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDateUploaded($value)
 */
class InventoryItem extends Model
{
    protected $table = 'InventoryItems';
    const CREATED_AT = 'date_created';
    const UPDATED_AT = 'date_modified';
//    protected $with = ['partBOMs.compPart.inventoryItems'];

    use \Hilco\SoftDeletes;

    public function partBOMs() {
        return $this->hasMany(PartBOM::class, 'main_part_id', 'part_id');
    }

    public function scopeInPlant(Builder $query, $plant) {
        return $query->where('plant', '=', $plant);
    }

    public function scopeWebFlagIn(Builder $query, $flags) {
        if (!is_array($flags)) $flags = [$flags];
        return $query->whereIn('web_flag', $flags);
    }

    public function scopeAvailableInPlant(Builder $query, $activePlants = false) {
        if ($activePlants === false) $activePlants = b2b()->activePlants();
        $query->where(function ($query) use ($activePlants) {
            foreach ($activePlants as $activePlant) {
                if (!strlen($activePlant->plant)) continue;
                $query->orWhere(function ($query) use ($activePlant) {
                    return $query
                        ->where('plant', $activePlant->plant)
                        ->whereIn('web_flag', config('hilco.inventoryItemWebFlags'))
                        ->where(function ($query) {
                            $query
                                ->where('part_status', '!=', 'Phase-out')
                                ->orWhere('max_available_qty', '>', '0')
                            ;
                        })
                    ;
                });
            }
            return $query;
        });
        return $query;
    }

    public function scopeInSilo(Builder $query, $plant = false) {
        if ($plant === false) $plant = b2b()->activePlant();
        $query->where(function ($query) use ($plant) {
            return $query
                ->where('plant', array_get($plant, 'plant'))
                ->whereIn('web_flag', config('hilco.inventoryItemWebFlags'))
                ->where(function ($query) {
                    $query
                        ->where('part_status', '!=', 'Phase-out')
                        ->orWhere('max_available_qty', '>', '0')
                    ;
                })
            ;
        });
        return $query;
    }

    public function scopeIsValid(Builder $query) {
        $query->where('part_status', '!=', 'Phase-out')->orWhere('max_available_qty', '>', '0');
    }

    public function getIsValidAttribute() {
        return $this->part_status != 'Phase-out' || $this->max_available_qty > 0;
    }

    public function getInStockAttribute() {
        return ($this->net_avail > 0);
    }
}

