<?php

namespace Hilco\Models;

/**
 * Hilco\Models\WebLandingPageDraft
 *
 * @property integer $id
 * @property string $name
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $context
 * @property-read mixed $default_context
 * @property-read mixed $web_layout
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageDraft whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageDraft whereName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageDraft whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageDraft whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageDraft whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageDraft named($name)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebModel joinContext($contextId = false)
 * @mixin \Eloquent
 * @property string $slug
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\WebLandingPageDraft whereSlug($value)
 */
class WebLandingPageDraft extends WebModel implements HasLandingPageInterface {

	protected $table = "WebLandingPageDrafts";
    protected $fillable = ['detail', 'slug', 'language', 'css'];

    public function slugUrl() {
        return route('draft.slug', [$this->slug]);
    }

    public function scopeVisible($query) {
        return $query;
    }

	use HasSlug, HasLandingPage;

    public static function IsExists($name = null, $slug = null){
        if(!isset($name) && !isset($slug)) return true;
        $query = null;

        if(isset($name)){
            if(!isset($query)) $query = self::named($name);
            else $query = $query->named($name);
        }

        if(isset($slug)){
            if(!isset($query)) $query = self::where('slug',$slug);
            else $query = $query->orWhere('slug',$slug);
        }
        $result = $query->count();
        return (isset($result) && $result > 0);
    }

    public function webGroups() {
        return $this->belongsToMany(WebGroup::class, 'WebGroup_WebLandingPage', 'weblandingpage_id', 'webgroup_id');
    }

    public function getParentRelationName()
    {
        return false;
    }

    public static function getAvailableLandingPageDrafts(){
        return WebLandingPageDraft::pluck('name', 'id');
    }

    public function webBrands()
    {
        return $this->belongsToMany(WebBrand::class, 'WebBrand_WebLandingPage', 'weblandingpage_id', 'webbrand_id');
    }

    public function getMetadataTitle() {
        $metadataTitle = $this->metadata->where('meta_name', 'title')->first();
        return isset($metadataTitle) ? $metadataTitle->meta_value : '';
    }

    public function getMetadataDescription() {
        $metadataDesc = $this->metadata->where('meta_name', 'description')->first();
        return isset($metadataDesc) ? $metadataDesc->meta_value : '';
    }
}
