<?php

namespace Hilco\Models;

/**
 * Class PromotionCurrencyTrigger
 * @package Hilco\Models
 * @property string $currency_code
 */
class PromotionCurrencyTrigger extends PromotionTriggerDetails {
    protected $table = 'PromotionCurrencyTriggers';
    protected $fillable = ['currency_code'];

    public function isTriggered (Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        return $this->currency_code == $soldToCustomer->getCurrency();
    }

    public function postTriggerOperation($soldToCustomer) {}
}