<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * M3 price list table matrix
 * @property-read string $PRRF
 */
class OPRMTX extends Model implements PriceIngestModel {
    protected $table = "OPRMTX";

    /**
     * @return string
     */
    public function getPriceList(): string {
        return $this->PRRF;
    }

    /**
     * @param $priceListTable
     * @param $priorityLevel
     * @param $value1
     * @param $value2
     * @param $value3
     * @param $value4
     * @param $value5
     * @return Collection<OPRMTX>
     */
    public static function findPriceListMatrixRecords ($priceListTable, $priorityLevel, $value1, $value2, $value3, $value4, $value5): Collection {
        $priorityLevel = $priorityLevel + 1; // the PC** columns on CROBJC are 0 - 9 but on OPRMTX the PREX values are 1-10
        return
            OPRMTX::where('PLTB', "$priceListTable")
                ->where('PREX', "$priorityLevel")
                ->where('OBV1', "$value1")
                ->where('OBV2', "$value2")
                ->where('OBV3', "$value3")
                ->where('OBV4', "$value4")
                ->where('OBV5', "$value5")
                ->get();
    }

    /**
     * @return string
     */
    public static function getTemporaryTableCreateSQL(): string {
        return <<<SQLEND
CREATE TEMPORARY TABLE `m3`.`OPRMTX_staging` (
  `CONO` varchar(3) NOT NULL,
  `PLTB` varchar(10) NOT NULL,
  `PREX` varchar(2) NOT NULL,
  `OBV1` varchar(8) NOT NULL,
  `OBV2` varchar(8) NOT NULL,
  `OBV3` varchar(8) NOT NULL,
  `PRRF` varchar(10) NOT NULL,
  `TXID` varchar(3) NOT NULL,
  `RGDT` varchar(8) NOT NULL,
  `RGTM` varchar(6) NOT NULL,
  `LMDT` varchar(8) NOT NULL,
  `CHNO` varchar(1) NOT NULL,
  `CHID` varchar(8) NOT NULL,
  `OBV4` varchar(8) NOT NULL,
  `OBV5` varchar(8) NOT NULL,
  `accountingEntity` varchar(3) NOT NULL,
  `deleted` varchar(5) NOT NULL,
  `timestamp` varchar(32) NOT NULL,
  `variationNumber` varchar(16) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
SQLEND;
    }

    /**
     * @return array
     */
    public static function getInsertableColumns(): array {
        return [
            'CONO',
            'PLTB',
            'PREX',
            'OBV1',
            'OBV2',
            'OBV3',
            'PRRF',
            'TXID',
            'RGDT',
            'RGTM',
            'LMDT',
            'CHNO',
            'CHID',
            'OBV4',
            'OBV5',
            'accountingEntity',
            'deleted',
            'timestamp',
            'variationNumber',
        ];
    }
}