<?php

namespace Hilco\Models;

class Call extends WebModel {
	protected $table = "Calls";

	public function salesRep() {
	    return $this->belongsTo(SalesRep::class, 'salesrep_id', 'id');
    }


    public static function getLatestCallFromListOfCustomers($customers) {
	    $latestCall = null;
	    foreach ($customers as $customer) {
	        $call = $customer->getLatestCall();
	        if ($call != null && ($latestCall == null || $latestCall->getStartTime() < $call->getStartTime())) {
	            $latestCall = $call;
            }
        }

        return $latestCall;
    }

    public function getStartTime() {
	    return $this->start_time;
    }
}