<?php

use Illuminate\Support\Facades\Storage;

if (! function_exists('assetImage')) {
    /**
     * Return Image Path.
     *
     * @param  string  $path
     * @return string
     */
    function assetImage($path) {
        $assets = Storage::disk('assets');
        if ($assets->has($path)) {
            return $assets->url($path);
        } else {
            return asset('images/nopic.png');
        }
    }
}


if (! function_exists('partUrl')) {
    function assetUrl($prefix, $key, $width = false, $height = false) {
        $api = config('hilco.assets.url', false);
        if ($api) {
            $url = "$api/$prefix/$key";
            if ($width) $url .= "/$width";
            if ($height) $url .= "/height";
            return $url;
        }
        $diskName = config('hilco.assets.disk', false);
        if ($diskName) {
            $disk = Storage::disk($diskName);
            if ($disk->has("$prefix/$key")) {
                return $disk->url("$prefix/$key");
            }
        }
        return null;
    }
}