<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 11/8/18
 * Time: 2:01 PM
 */

namespace Hilco\Models;

/**
 * Hilco\Models\QueuedOrderPartLine
 *
 * @property mixed $id
 * @property mixed $part_id
 * @property mixed $quantity
 * @property float $unit_price
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\OrderItem[] $items
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine wherePlantId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereInvoiceNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereBilltoCustomersegmentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereSoldtoCustomersegmentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereFob($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine wherePaymentTerms($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereTaxAmt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereFreightAmt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereInvoiceDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereShipDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereCarrier($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereShipVia($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereCustomerPo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereShippingPolicy($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereDeletedAt($value)
 * @mixin \Eloquent
 * @property boolean $isKit
 * @property-read \Hilco\Models\Part $part
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine wherePartId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereQuantity($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereUnitPrice($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereIsKit($value)
 * @property mixed $salesorder_id
 * @property integer $line_number
 * @property integer $line_order
 * @property string $line_suborder
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereSalesorderId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereLineNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereLineOrder($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderPartLine whereLineSuborder($value)
 */
class QueuedOrderPartLine extends WebModel
{
    protected $table = 'QueuedSalesOrderPartLines';

    public function part() {
        return $this->belongsTo(Part::class, 'part_id');
    }

    public function priceLists() {
        return $this->hasMany(PriceList::class, 'part_id', 'part_id');
    }

    public function getPriceListPriceAttribute() {
        $priceLists = $this->priceLists->sortByDesc('quantity_level');
        foreach ($priceLists as $priceList) {
            if ($this->quantity >= $priceList->quantity_level) {
                return $priceList->price;
            }
        }
        return null;
    }
}