@if($edit)
    <div class="mceNonEditable component-container" data-component-key="promoBanners">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('app.promotions')</h4>
        <p>@lang('app.displays_promotion_banner_across_the_entire_width_of_the_page_that_rotate')</p>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('promoBanners', {
            menuText: '@lang('app.promotions')',
            bladeTemplate: 'hilco::components.promoBanners',
            init: function (body) {
            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    <div id="promotions-carousel" class="owl-carousel owl-theme">
        @foreach(b2b()->eligiblePromotions() as $promotion)
            @if ($promotion->visible && strlen($promotion->homepage_banner_text))
                @include('promotions.promoBlock', ['homepage' => true, 'link' => $promotion->homepage_banner_link, 'text' => $promotion->homepage_banner_text])
            @endif
        @endforeach
    </div>

    <script type="text/javascript">
        $(document).ready(function () {
            $('#promotions-carousel').owlCarousel({
                center: true,
                items: 1,
                @if(count(b2b()->eligiblePromotions()) > 1) loop: true, @endif
                autoplay: true,
                autoplayTimeout: {{ isset($bannerTimeout) ? $bannerTimeout : '3000' }},
                autoplayHoverPause: true,
                dots: true,
            });
        });
    </script>
@endif