<?php
/**
 * Created by PhpStorm.
 * User: steven
 * Date: 7/31/19
 * Time: 5:57 PM
 */

namespace Hilco\GuzzleWrappers\RequestBuilders;


class RequestBuilder
{
    protected $attributes;
    public function __construct($attributes)
    {
        $this->attributes = $attributes;
    }

    /*
     * Cleans an array of requst attributes of null values that were mis-assigned, to prevent garbage responses
     *  from Vertex/M3 api responses.
     */
    public function noNulls (array $requestAttributes){
        $noNullArray = [];
        foreach($requestAttributes as $key => $value){
            if($value){
                $noNullArray[$key] = $value;
            }
        }
        return $noNullArray;

    }

    public function buildQueryArray(){
        $this->attributes = $this->noNulls($this->attributes);
        return ['query' => $this->attributes];
    }
    public function buildAcceptableJson(&$request){
        $request['headers'] =  ['Accept' => 'application/json'];
    }

}