<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Auth;
use DB;

/**
 * Hilco\Models\WebLink
 *
 * @property integer $id
 * @property integer $web_link_category_id
 * @property string $links
 * @property string $type
 * @property string $date_modified
 * @property string $deleted_at
 */
class WebLink extends WebModel {
    protected $table = "WebLinks";
    protected $fillable = ['user_visibility', 'link','type','order','display_name','webSiloIds','web_link_category_id'];
    public static $userVisibility = ['Hidden', 'Visible For All', 'For Anonymous User', 'For Logged In User'];
    public static $types =[
//        'hilco-route' => 'Hilco Route',
        'landing_page' => 'Landing Page',
//        'asset' => 'Asset',
        'general' => 'Any URL',
    ];
    public static $typeValues = [
//        'hilco-route',
        'landing_page',
        'asset',
        'general',
    ];

    /**
     * @return BelongsToMany
     */
//    public function webSilos() {
//        return $this->belongsToMany(WebSilo::class, 'WebLink_WebSilo', 'weblink_id', 'websilo_id')
//            ->withPivot(['is_visible', 'display_name', 'type', 'link']);
//    }

    public function webLinkWebSiloJoins() {
        return $this->hasMany(WebLink_WebSilo::class, 'weblink_id', 'id');
    }

//    public function getActiveWebSiloAttribute() {
//        return $this->webSilos->where('id', b2b()->activeWebSilo()->id)->first();
//    }

    public function category() {
        return $this->belongsTo(WebLinkCategory::class, 'web_link_category_id');
    }

    public function webLinkCategory() {
        return $this->belongsTo(WebLinkCategory::class, 'web_link_category_id');
    }

//    public function setWebSiloIdsAttribute($ids) {
//        $this->save();
//        $this->webSilos()->sync($ids);
//    }

    public function getUrl(){
        if ($this->type == 'landing_page') {
            $url = route('landingpage.slug', [$this->link]);
        } else if ($this->type == 'asset') {
            $url = config('hilco.assets.url');
            $url .= '/' . $this->link;
        } else {
            $url = url($this->link);
        }

        return $url;
    }

    /**
     * @param $query
     * @return mixed
     */
    public function scopeAvailableForUser($query) {
        $user = Auth::user();
        if (isset($user)) {
            $query->whereRaw('WebLinks.user_visibility IN (1, 3)');
        } else {
            $query->whereRaw('WebLinks.user_visibility IN (1, 2)');
        }

        $webSilo = b2b()->activeWebSilo();
        return $query->forWebSilo($webSilo->id);
    }

    public function scopeForWebSilo ($query, $webSiloId) {
        $query->whereHas('webLinkWebSiloJoins', function ($query) use ($webSiloId) {
            return $query->where('websilo_id', '=', $webSiloId)->where('WebLink_WebSilo.is_visible', '=', 1);
        });
    }
}
