<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Hilco\Models\CustomerPharmacyInfo
 *
 * @property mixed $id
 * @property string $license_number
 * @property string $license_state
 * @property string $license_expiration_date
 * @property string $npi_number
 * @property string $update_person
 * @property string $update_date
 * @property string $state_license_number
 * @property string $addr_1
 * @property string $addr_2
 * @property string $addr_3
 * @property string $addr_4
 * @property string $city
 * @property string $state
 * @property string $postal_cd
 * @property string $country
 * @property string $medpro_number
 * @property string $first_name
 * @property string $last_name
 */
class CustomerPharmacyInfo extends UuidModel {
	protected $table = 'CustomerPharmacyInfos';

    public function customerPharmacyLicenses(): HasMany {
        return $this->hasMany(Customer_PharmacyLicense::class, 'customerpharmacyinfo_id', 'id');
    }

	public function scopeIsRX($query){
		$query->where('npi_number','!=',"''")->where('npi_number','!=',"N/A");
	}

	public function checkRx(){
		return (isset($this->npi_number) && $this->npi_number != '' && $this->npi_number !='N/A');
	}

}