<?php

namespace Hilco\Models;

use Auth;
use DB;
use Illuminate\Database\Eloquent\Model;

class WebCart extends WebModel
{
    protected $table = 'WebCarts';
    protected $fillable = ['quantity'];

    public function webPart() {
        return $this->hasOne(WebPart::class, 'part_number', 'part_number');
    }

    public function webUser() {
        return $this->hasOne(WebUser::class, 'webuser_id', 'id');
    }

    public function priceList() {
//        return $this->hasOne(PriceList::class)
    }

    public function scopeForUser($query, $webuserId) {
        return $query->where('webuser_id', $webuserId);
    }

    public function scopePartNumber($query, $partNumber) {
        return $query->where('part_number', $partNumber);
    }

//    public function product() {
//        return $this->belongsTo(Product::class);
//    }

    public function getExtendedPriceAttribute() {
        return $this->webPart->getCustomerPrice($this->quantity) * $this->quantity;
    }

    public static function add(WebPart $webPart, $quantity = 1)
    {
        $instance = new static;
        $instance->webuser_id = Auth::id();
        $instance->part_number = $webPart->part_number;
        $instance->quantity = $quantity;
        $instance->save();
        return $instance;
    }

    public static function remove($userId, $partNumber)
    {
        $instance = new static;
        return $instance::where(['part_number' => $partNumber, 'webuser_id' => $userId])->delete();
    }

    public static function cartItems($webUserId = false, $billToCustomerSegmentId = false) {
        if ($webUserId === false)
            $webUser = auth()->user();
        else $webUser =
            WebUser::find($webUserId);
        if (is_null($webUser)) return [];

        $soldToCustomer = $webUser->active_customer;

        if ($billToCustomerSegmentId === false) {
            $billToCustomer = $soldToCustomer->activeSegment->billToCustomer;
            $billToCustomerSegment = $billToCustomer->activeSegment;
        } else {
            $billToCustomerSegment = CustomerSegment::find($billToCustomerSegmentId);
        }
        if (is_null($billToCustomerSegment)) return [];

        $defPriceList = $billToCustomerSegment->def_price_list;

        $cartItems = self::forUser($webUser->id)->with(['webPart' => function ($query) use ($webUser) {
            return $query->with([
                'part' => function ($query) use ($webUser) {
                    $query->with(['prices' => function ($query) use ($webUser) {
                        $query
                            ->where('currency', $webUser->currency)
                            ->where('price_list', $webUser->default_price_list)
    //                        ->whereRaw('PriceLists.quantity_level >= WebCarts.quantity')
                        ;
                    }]);
                },
                'promos' => function ($query){
                   return $query->with('rules');
                },
            ])->with('webFamily');
        }])->get();

        $totalPromoQuantity = 0;
        $partsByPrice = [];
        $priceListQuantityArray = [];
        foreach ($cartItems as $cartItem) {
            if (isset($priceListQuantityArray[$cartItem->webPart->id])) {
                $priceListQuantityArray[$cartItem->webPart->id] += $cartItem->quantity;
            } else {
                $priceListQuantityArray[$cartItem->webPart->id] = $cartItem->quantity;
            }

            foreach($cartItem->webPart->webFamily->webCollections as $collection) {
                if ($collection->id == config("hilco.jpPromoCollectionId") && !in_array($cartItem->webPart->webFamily->id, explode('^', config('hilco.jpPromoIgnoreId')))) {
                    $totalPromoQuantity += $cartItem->quantity;
                    $partsByPrice[''.$cartItem->webPart->getCustomerPrice($cartItem->quantity)][$cartItem->id] = $cartItem->quantity;
                    break;
                }
            }
        }

        foreach ($cartItems as $key => $cartItem) {
            if (isset($priceListQuantityArray[$cartItem->webPart->id])) {
                $cartItems[$key]->priceListQuantity = $priceListQuantityArray[$cartItem->webPart->id];

                $part = $cartItem->webPart->part;
                $priceList = PriceList::where('currency', WebUser::activeCurrency())->where('price_list', '=', $defPriceList)->where('part_id', '=', $part->id)->where('quantity_level', '<=', $priceListQuantityArray[$cartItem->webPart->id])->orderBy('quantity_level', 'DESC')->first();
                $price = $priceList !== null ? $priceList->price : $part->list_price;

                $cartItems[$key]->priceListPrice = $price;
                $cartItems[$key]->discountedPrice = $price;

                if ($priceList !== null && !$priceList->contract_flag) {
                    $customerDiscounts = CustomerDiscount::where('customer_id', '=', $soldToCustomer->id)
                        ->where(function ($query) use ($part) {
                            $query->where('productfamily_id', '=', $part->productfamily_id);
                            $query->orWhere('part_id', '=', $part->id);
                        })
                        ->where('deleted_at', '=', DB::raw('0'))
                        ->get();

                    if ($customerDiscounts !== null) {
                        foreach ($customerDiscounts as $customerDiscount) {
                            $cartItems[$key]->discountedPrice -= round($cartItems[$key]->priceListPrice  * ($customerDiscount->disc_val / 100), 2);
                        }
                    }
                }

                $cartItems[$key]->calculatedPrice = $cartItems[$key]->discountedPrice * $cartItems[$key]->quantity;
            }
        }

        if ($totalPromoQuantity > 12) {
            ksort($partsByPrice, SORT_NUMERIC);

            $discountedFrameCount = $totalPromoQuantity > 13 ? 2 : 1;

            $freeWebCartIds = [];
            foreach ($partsByPrice as $price => $webCartIds) {
                foreach ($webCartIds as $webCartId=>$quantity) {
                    $freeWebCartIds[$webCartId] = min($discountedFrameCount, $quantity);
                    $discountedFrameCount -= $freeWebCartIds[$webCartId];

                    if ($discountedFrameCount <= 0) break;
                }
                if ($discountedFrameCount <= 0) break;
            }

            foreach ($cartItems as $key=>$cartItem) {
                if(isset($freeWebCartIds[$cartItem->id])) {
                    $cartItems[$key]->promo_quantity = $freeWebCartIds[$cartItem->id];
                    $cartItems[$key]->promoPrice = $cartItems[$key]->discountedPrice * ($cartItems[$key]->quantity - $cartItems[$key]->promo_quantity);
                }
            }
        }

        return $cartItems;
    }
    
    public static function getCartDiscount(){
        return rulesChecker::checkPromoRules(app('generalPromos'));
    }
    
}
