<?php
/**
 * Created by PhpStorm.
 * User: steven
 * Date: 7/29/19
 * Time: 9:46 AM
 */

namespace Hilco\RateShopHelper;


use Hilco\GuzzleWrappers\APIGuzzleWrapper;
use Illuminate\Support\Facades\DB;
use Log;

class RateShop_v2
{
    const HILCO_HANDLING_FEE = 3;


    function rateShopUSAWithAccount($carrierCodes, $weight, $volume, $toState, $toCode, $fromCode, $rates)
    {
        $data = [];
        $dbResult = DB::connection()
            ->table('RateShopAPIDetails')
            ->join('Carriers', 'Carriers.carrier_code', '=', 'RateShopAPIDetails.hilco_carrier_code')
            ->whereIn('RateShopAPIDetails.hilco_carrier_code', $carrierCodes)
            ->select(['RateShopAPIDetails.*', 'Carriers.carrier_desc'])
            ->get();
        $dbResult = json_decode(json_encode($dbResult), true);
        foreach ($dbResult as $row) {
            $data[$row['api_carrier']][$row['residential']][] = $row;
        }


        $returnData = $this->rateShopUSAWithData($data, $weight, $volume, $toCode, $fromCode, $rates);

        foreach ($returnData as $hilco_carrier_code => $data) {
            if (isset($data['rate'])) {
                $returnData[$hilco_carrier_code]['rate'] += self::HILCO_HANDLING_FEE;
            }
        }
        return $returnData;
    }

    function retrieveRateShopAPIDetailsForGroupCode($hilcoCarrierGroupCode, $eligibleMethods = null){
        $data = [];

        $dbResult = DB::connection()
            ->table('RateShopAPIDetails')
            ->join('RateShopGroups', function ($join) {
                return
                    $join
                        ->on('RateShopAPIDetails.delivery_method', '=', 'RateShopGroups.delivery_method')
                        ->on('RateShopAPIDetails.delivery_term', '=', 'RateShopGroups.delivery_term')
                ;
            })
            ->join('DeliveryMethods', 'DeliveryMethods.delivery_method_code', '=', 'RateShopAPIDetails.delivery_method')
            ->where('group_code', '=', $hilcoCarrierGroupCode);

        if(!is_null($eligibleMethods)){
            $dbResult = $dbResult->orWhereIn('RateShopAPIDetails.delivery_method', $eligibleMethods);
        }

        $dbResult = $dbResult->groupBy('RateShopAPIDetails.delivery_method', 'RateShopAPIDetails.delivery_term')
            ->select(['RateShopAPIDetails.*', 'DeliveryMethods.description'])
            ->get();
        $dbResult = json_decode(json_encode($dbResult), true);
        foreach ($dbResult as $row) {
            $data[$row['api_carrier']][$row['residential']][] = $row;
        }

        return $data;
    }

    function rateShopUSA($hilcoCarrierGroupCode, $weight, $volume, $toCode, $fromCode)
    {
        $data = [];
        $dbResult = DB::connection()
            ->table('RateShopAPIDetails')
            ->join('RateShopGroups', 'RateShopAPIDetails.delivery_method', '=', 'RateShopGroups.delivery_method')
            ->join('DeliveryMethods', 'DeliveryMethods.delivery_method_code', '=', 'RateShopAPIDetails.delivery_method')
            ->where('group_code', '=', $hilcoCarrierGroupCode)
            ->select(['RateShopAPIDetails.*', 'DeliveryMethods.description'])
            ->get();
        $dbResult = json_decode(json_encode($dbResult), true);
        foreach ($dbResult as $row) {
            $data[$row['api_carrier']][$row['residential']][] = $row;
        }

        $returnData = RateShop_v2::rateShopUSAWithData($data, $weight, $volume, $toCode, $fromCode);
        foreach ($returnData as $hilco_carrier_code=>$data) {
            if (isset($data['rate'])) {
                $returnData[$hilco_carrier_code]['rate'] += self::HILCO_HANDLING_FEE;
            }
        }

        return $returnData;
    }
    public function mapToCarrierCodes($rates){

    }

    function getRatesByDimensions($weight, $volume, $toCode, $fromCode, $additionalAttributes = []){
        $apiGuzzleWrapper = new APIGuzzleWrapper();
        $response = $apiGuzzleWrapper->get('v4/getRates',  [
            'query' => [
                'weight' => $weight,
                'volume' => $volume,
                'toCode' => $toCode,
                'fromCode' => $fromCode
            ],
            'headers' => ['Accept' => 'application/json']
        ]);
        $jsonRateContents = $response->getBody()->getContents();
        $rates = json_decode($jsonRateContents, true);
        $rates = $rates['details'];
/*        $string = substr($response, strpos($response, "<?xml version=\"1.0\"?>"), strpos($response, '</RateResponse>') + 1);*/
//        $simpleXML = simplexml_load_string($string, "SimpleXMLElement", LIBXML_NOWARNING);
//        $rateShopUtility = new RateShopUtility(['simpleXML' => $simpleXML]);
//        $rates  = $rateShopUtility->getRates();
        return $rates;
    }

    // Now indexes by Delivery Methods.
    function indexRatesByCarrierCodes($ratesFromProcessWeaver, $rateShopAPIDetailsData){
        $carrierCodeRateArray = [];
        $carrierTransitCodeArray = [];
        // Create an array indexed by carrier-transit to match.
        // Also api_code = transit_code for some reason
        foreach($ratesFromProcessWeaver as $processWeaverRate){
            $carrierName = $processWeaverRate['carrier_name'];
            $apiCode = $processWeaverRate['api_code'];
            if(!isset($carrierTransitCodeArray[$carrierName])){
                $carrierTransitCodeArray[$carrierName] = [$apiCode => $processWeaverRate];
            }else{
                $carrierTransitCodeArray[$carrierName][$apiCode] = $processWeaverRate;
            }
        }
        Log::error(json_encode($carrierTransitCodeArray));
        Log::error(json_encode($rateShopAPIDetailsData));
        foreach($rateShopAPIDetailsData as $apiCarrier => $carrierOptionsArray){
            foreach($carrierOptionsArray as $index => $rateShopAPIDetailsRows){
                foreach($rateShopAPIDetailsRows as $rateShopAPIDetailsRow){
                    $apiCarrier = $rateShopAPIDetailsRow['api_carrier']; // e.g., UPS, FedEx, ICS, etc
                    $apiCode = $rateShopAPIDetailsRow['api_code'];  // e.g., 07, 11, INTERNATIONAL_ECONOMY, etc
                    if(in_array($apiCarrier, array_keys($carrierTransitCodeArray))){ // if the rates returned from PW include rates from carrier in $apiCarrier
                        $pwCarrierRatesArray = $carrierTransitCodeArray[$apiCarrier];
                        if(in_array($apiCode, array_keys($pwCarrierRatesArray))){
                            $pwCarrierRateObj = $pwCarrierRatesArray[$apiCode];
                            $deliveryMethod = $rateShopAPIDetailsRow['delivery_method'];
                            $deliveryTerm = $rateShopAPIDetailsRow['delivery_term'];
                            $pwCarrierRateObj['delivery_method'] = $deliveryMethod;
                            $pwCarrierRateObj['delivery_term'] = $deliveryTerm;
                            $carrierCodeRateArray[$deliveryMethod . '-' . $deliveryTerm] = $pwCarrierRateObj;
                        }
                    }
                }
            }
        }

        return $carrierCodeRateArray;
    }

    function rateShopUSAWithData($data, $weight, $volume, $toCode, $fromCode, $rates) {
//        $rates = $this->getRatesByDimensions($weight, $volume, $toCode, $fromCode);
        $returnData = $this->indexRatesByCarrierCodes($rates, $data);

        return $returnData;
    }
}