@if($edit)
    <div class="mceNonEditable component-container" data-component-key="textDescription">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.text_description')</h4>
        <p>@lang('hilco::app.text_description_description')</p>

        <div>
            Header: &nbsp; <div style="display: inline;" class="header-preview"> @if($header) {{ $header }} @else None @endif</div><br>
            Body: &nbsp; <div style="display: inline;" class="body-preview"> @if($body) {{ $body }} @else None @endif</div><br>
            Button Text: &nbsp; <div style="display: inline;" class="button-preview"> @if($button) {{ $button }} @else None @endif</div><br>
            Button Link: &nbsp; <div style="display: inline;" class="link-preview"> @if($link) {{ $link }} @else None @endif</div><br>
            Button Location: &nbsp; <div style="display: inline;" class="button-location-preview"> @if($buttonLocation) {{ ucfirst($buttonLocation) }} @else None @endif</div><br>
        </div>

        {{--<div style="border: 1px solid black; border-radius: 5px; margin: 5px">--}}
        {{--<h5 class="header-preview" style="display: inline-block; padding-right: 10px;">{{ $header }}</h5> <button class="btn btn-sm btn-primary button-preview" @if($button != null && $button != "") style="display: inline-block" @else style="display: none"@endif>{{ $button }}</button>--}}
        {{--<div class="body-preview" style="font-weight: normal; font-size: 13px">{{ $body }}</div>--}}
        {{--</div>--}}
        <button class="btn btn-md btn-primary set-text-area" data-header-text="{{ $header }}" data-body-text="{{ $body }}" @if($button == null || $button == '') data-button-check="false" @else data-button-check="true" @endif data-button-text="{{ $button }}" data-button-link="{{ $link }}" data-button-location="{{ $buttonLocation }}">Edit Text Area</button>
    </div>

@endif

@if($script)
    <script type="text/javascript">
        registerComponent('textDescription', {
            menuText: '@lang('hilco::app.text_description')',
            bladeTemplate: 'hilco::components.textDescription',
            init: function (body) {

                $(body).on('click', '.set-text-area', function () {
                    $(document).off('click', '#text_description_submit');

                    var mainComponent = $(this).closest('.component-container');

                    var button = $(this);

                    var currentHeader = $(this).attr('data-header-text');
                    document.getElementById("text_description_header").value = currentHeader;

                    var currentButtonCheck = $(this).attr('data-button-check');
                    var check = document.getElementById("include_button");
                    if(currentButtonCheck == 'true'){
                        $(check).prop( "checked", true );
                        $("#button_options").show();
                    }else{
                        $(check).prop( "checked", false );
                        $("#button_options").hide();
                    }

                    document.getElementById("include_button").value = currentButtonCheck;
                    var currentButtonText = $(this).attr('data-button-text');
                    document.getElementById("button_text").value = currentButtonText;
                    var currentButtonLink = $(this).attr('data-button-link');
                    document.getElementById("button_link").value = currentButtonLink;

                    var currentButtonLocation = $(this).attr('data-button-location');
                    if(currentButtonLocation == 'header'){
                        $("#radio_header").prop('checked', true);
                    }else{
                        $("#radio_footer").prop('checked', true);
                    }

                    var currentBody = $(this).attr('data-body-text');
                    document.getElementById("text_description_body").value = currentBody;

                    $("#text-description-modal").find(".overlay-options").hide();

                    $("#text-description-modal").modal('show');

                    $(document).on('click', '#text_description_submit', function (e){
                        var header = document.getElementById("text_description_header").value;
                        var buttonCheck = document.getElementById("include_button").checked;
                        if(buttonCheck){
                            var buttonText = document.getElementById("button_text").value;
                            var buttonLink = document.getElementById("button_link").value;
                            var buttonLocation = $("input[name='buttonLocation']:checked").val();
                        }else{
                            var buttonText = '';
                            var buttonLink = '';
                            var buttonLocation = '';
                        }

                        var body = document.getElementById("text_description_body").value;

                        $(button).attr('data-header-text', header);
                        $(button).attr('data-button-check', buttonCheck);
                        $(button).attr('data-button-text', buttonText);
                        $(button).attr('data-button-link', buttonLink);
                        $(button).attr('data-button-location', buttonLocation);
                        $(button).attr('data-body-text', body);

                        $(mainComponent).find('.header-preview').html(header);
                        $(mainComponent).find('.body-preview').html(body);
                        if(buttonText == ''){
                            // $(mainComponent).find('.button-preview').hide();
                            $(mainComponent).find('.button-preview').html('None');
                            $(mainComponent).find('.link-preview').html('None');
                            $(mainComponent).find('.button-location-preview').html('None');

                        }else{

                            // $(mainComponent).find('.button-preview').show();
                            $(mainComponent).find('.button-preview').html(buttonText);
                            $(mainComponent).find('.link-preview').html(buttonLink);

                            if(buttonLocation == 'header'){
                                $(mainComponent).find('.button-location-preview').html('Header');
                            }else{
                                $(mainComponent).find('.button-location-preview').html('Footer');
                            }

                        }
                        $("#text-description-modal").modal('hide');
                    });
                });
            },
            serialize: function (componentNode) {
                var button = $(componentNode).find('button.set-text-area');

                var header = $(button).data('header-text');
                var body = $(button).data('body-text');
                var buttonText = $(button).data('button-text');
                var buttonLink = $(button).data('button-link');
                var buttonLocation = $(button).data('button-location');

                var data = {
                    header: header,
                    body: body,
                    button: buttonText,
                    link: buttonLink,
                    buttonLocation : buttonLocation
                };

                return data;
            },
        });
    </script>
@endif

@if($view)
    <div id="text-description-component">
        <h4 style="display: inline-block; padding-right: 10px;">{{ $header }}</h4>
        @if(($button != null && $button != "") && ($buttonLocation != null && $buttonLocation == 'header')) <button class="btn btn-md btn-primary" href="{!! $link !!}">{{ $button }}</button>@endif
        <p>{{ $body }}</p>
        @if(($button != null && $button != "") && ($buttonLocation != null && $buttonLocation == 'footer')) <button class="btn btn-md btn-primary" href="{!! $link !!}">{{ $button }}</button>@endif
    </div>
@endif