<?php

namespace Hilco\Models;
use DB;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Class PromotionCustomerCategoryTrigger
 * @package Hilco\Models
 */
class PromotionCustomerCategoryTrigger extends PromotionTriggerDetails {
    protected $table = 'PromotionCustomerCategoryTriggers';

    public function customerCategories(): BelongsToMany {
        return $this->belongsToMany(CustomerCategory::class, 'PromotionCustomerCategoryTrigger_CustomerCategory', 'promotioncustomercategorytrigger_id', 'customercategory_id')
                    ->wherePivot('deleted_at', '=', DB::raw(0))
                    ->withPivot(['is_excluded']);
    }

    public function promotionCustomerCategoryTriggerCustomerCategories(): HasMany {
        return $this->hasMany(PromotionCustomerCategoryTrigger_CustomerCategory::class, 'promotioncustomercategorytrigger_id', 'id');
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        $soldToCustomerCategory = $soldToCustomer->overrideCustomerCategory;
        return !is_null($this->customerCategories()->where('CustomerCategories.id', $soldToCustomerCategory->id)->wherePivot('is_excluded', '=', 0)->first());
    }

    public function postTriggerOperation($soldToCustomer)
    {
        // TODO: Implement postTriggerOperation() method.
    }
}