<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\BusinessChain_Customer
 * @property-read integer $id
 * @property-read string $business_chain
 * @property-read integer $businesschain_id
 * @property-read string $cust_no
 * @property-read integer $customer_id
 * @property-read string $valid_from_date
 * @property-read string $valid_to_date
 * @property-read string $member_number
 * @property-read BusinessChain $businessChain
 * @property-read Customer $customer
 */
class BusinessChain_Customer extends WebModel {
    protected $table = "BusinessChain_Customer";

    /**
     * @return BelongsTo
     */
    public function businessChain(): BelongsTo {
        return $this->belongsTo(BusinessChain::class, "businesschain_id", "id");
    }

    /**
     * @return BelongsTo
     */
    public function customer(): BelongsTo {
        return $this->belongsTo(Customer::class, "customer_id", "id");
    }
}