<?php
/**
 * Created by PhpStorm.
 * User: steven
 * Date: 10/23/19
 * Time: 11:36 AM
 */

namespace Hilco\Models;
use Log;



/**
 * Class BODImportLog
 * @package Hilco\Models
 * @property  string $bod_id
 * @property string $party_id
 * @property  string $result
 * @property string $bod_type
 * @property string $action_expression
 * @property string $bod
 * @property string $exception
 * @property string $misc
 * @property datetime $import_time
 * @property int $import_time_int : Import time converted to an indexable int.
 * @property  string $table
 * @property bigint $C_ID
 * @property
 * @
 *
 */

use Illuminate\Support\Facades\DB;

class BODImportLog extends WebModel
{
    protected $table = "BODImportLogs";


    public static function createBODImportLog($BODImportLogAttributes){
        $BODImportLog = new BODImportLog();
        $BODImportLog->bod_id = array_get($BODImportLogAttributes, 'bod_id');
        $BODImportLog->party_id = array_get($BODImportLogAttributes, 'party_id');
        $BODImportLog->result = array_get($BODImportLogAttributes, 'result');
        $BODImportLog->bod_type = array_get($BODImportLogAttributes, 'bod_type');
        $BODImportLog->action_expression = array_get($BODImportLogAttributes, 'action_expression');
        $BODImportLog->bod = array_get($BODImportLogAttributes, 'bod');
        $BODImportLog->exception = array_get($BODImportLogAttributes, 'exception');
        $BODImportLog->misc = array_get($BODImportLogAttributes, 'misc');
        $BODImportLog->import_time = array_get($BODImportLogAttributes, 'import_time');
        $BODImportLog->import_time_int = array_get($BODImportLogAttributes, 'import_time_int');
        $BODImportLog->C_ID = array_get($BODImportLogAttributes, 'C_ID');
        if(isset($BODImportLogAttributes['reimport'])){
            $BODImportLog->reimport = array_get($BODImportLogAttributes, 'reimport');
        }
        $BODImportLog->save();

    }

    public static function getFromLogs($BODType = null , $options)
    {

        $logger = Log::getMonolog();

//        $batch  = BODImportLog::where('bod_type', '=', $BODType);

//        dd($BODType, $options);
        if($BODType != null){
            $batch = BODImportLog::where('bod_type', '=', $BODType);

            $thirtyDaysAgoCarbon = \Carbon\Carbon::today()->subDays(60);
            $thirtyDaysAgoDateTimeStamp = $thirtyDaysAgoCarbon->toDateTimeString();
            $batch = $batch->where('import_time', '>', $thirtyDaysAgoDateTimeStamp);
        }else{ // If no BOD type was passed in and no further options were set, check BODs within the last thirty days. 
            $thirtyDaysAgoCarbon = \Carbon\Carbon::today()->subDays(60);
            $thirtyDaysAgoDateTimeStamp = $thirtyDaysAgoCarbon->toDateTimeString();
////            dd($thirtyDaysAgoTimestamp);
            $batch = BODImportLog::where('import_time', '>', $thirtyDaysAgoDateTimeStamp);
            return [];
        }
        if(isset($options['C_ID']) and $options['C_ID'] != 0 and $options['C_ID'] != -1){
            $batch = $batch->where('C_ID', '=', $options['C_ID']);
        }

        if(isset($options['partyID'])){
            $batch = $batch->where('party_id', '=', $options['partyID']);
        }
        $logger->info("RUNNING BOD IMPORT LOG QUERY: \n " . $batch->toSql());
        $logger->info(var_export($batch->getBindings()));
//        $batch = BODImportLog::limit('1')->get();
        return $batch->get();
    }

    /**
     * @return string
     */
    public function getBod()
    {
        return $this->bod;
    }


}