<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:35 AM
 */

namespace Hilco\Listeners;


use Hilco\Events\UserWasRegistered;
use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Support\Facades\Mail;


/**
 * Sends an email to the customer to provide information about their new account.
 *
 * Class EmailNewUserConfirmation
 * @package Hilco\Listeners
 */
class EmailNewUserConfirmation
{

    public function construct() {

    }

    public function handle(UserWasRegistered $event)
    {
        Mail::send(
            'hilco::emails.newUserConfirmation',
            [
                'webUser' => $event->webUser,
                'temporaryPassword' => $event->temporaryPassword,
                'url' => config('hilco.b2b.url')
            ],
            function ($mail) use ($event) {
                $mail->to($event->webUser->email);

                foreach (config('hilco.emailDestinations.newUserConfirmation.to', []) as $to) {
                    if ($to) $mail->to($to);
                }

                foreach (config('hilco.emailDestinations.newUserConfirmation.bcc', []) as $bcc) {
                    if ($bcc) $mail->bcc($bcc);
                }

                $mail->subject(trans('hilco::email.newUserConfirmationSubject'));
            }
        );
    }
}