<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:10 AM
 */

namespace Hilco\Events;


use Hilco\Models\WebUser;
use Illuminate\Queue\SerializesModels;

class UserWasRegistered extends Event
{
    use SerializesModels;

    /** @var WebUser */
    public $webUser;

    /**
     * True if user self-registered, false if UAC created
     * @var bool
     */
    public $selfCreated;

    /**
     * @var string
     */
    public $temporaryPassword;

    public function __construct(WebUser $webUser, $temporaryPassword = false, $selfCreated = true) {
        $this->webUser = $webUser;
        $this->selfCreated = $selfCreated;
        $this->temporaryPassword = $temporaryPassword;
    }
}