<?php

namespace Hilco\Providers;

use Hilco\Events\UserWasRegistered;
use Hilco\Listeners\EmailNewUserAlert;
use Hilco\Listeners\EmailNewUserConfirmation;
use Illuminate\Contracts\Events\Dispatcher as DispatcherContract;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class HilcoB2BSharedEventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        UserWasRegistered::class => [
            EmailNewUserAlert::class,
            EmailNewUserConfirmation::class,
        ],
    ];

    /**
     * Register any other events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();
    }
}
