<?php

namespace Hilco\Models;

trait TracksLastModified {
    /**
     * OVERRIDES Model::update()
     * @inheritDoc
     */
    public function update (array $attributes = [], array $options = []): bool {
        if (! \Arr::has($attributes, 'lastmodifiedby_id') && auth()->check()) {
            $attributes['lastmodifiedby_id'] = auth()->user()->id;
        }
        return parent::update($attributes, $options);
    }

    /**
     * OVERRIDES Model::updateOrFail()
     * @inheritDoc
     */
    public function updateOrFail (array $attributes = [], array $options = []): bool {
        if (! \Arr::has($attributes, 'lastmodifiedby_id') && auth()->check()) {
            $attributes['lastmodifiedby_id'] = auth()->user()->id;
        }
        return parent::updateOrFail($attributes, $options);
    }

    /**
     * OVERRIDES Model::updateQuietly()
     * @inheritDoc
     */
    public function updateQuietly(array $attributes = [], array $options = []): bool {
        if (! \Arr::has($attributes, 'lastmodifiedby_id') && auth()->check()) {
            $attributes['lastmodifiedby_id'] = auth()->user()->id;
        }
        return parent::updateQuietly($attributes, $options);
    }
}