<?php

namespace Hilco\Excel;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ExcelArrayExport implements FromArray, WithHeadings, WithStyles {
    private $bold;
    private $array;
    public function __construct($array, $bold = true){
        $this->array = $array;
        $this->bold = $bold;
    }

    /**
     * @return array
     */
    public function array(): array
    {
        return $this->array;
    }

    public function headings(): array
    {
        if (count($this->array) > 0){
            return array_keys($this->array[0]);
        }else{
            return [];
        }
    }

    public function styles(Worksheet $sheet)
    {
        if ($this->bold){
            return [
                // Style the first row as bold text.
                1    => ['font' => ['bold' => true]],
            ];
        }else{
            return [];
        }

    }
}