<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 4/2/19
 * Time: 10:13 AM
 */

namespace Hilco\Models;


use DB;
use Illuminate\Database\Query\JoinClause;

class WebModelTranslation extends WebModel
{
    protected $table = 'WebModelTranslations';
    protected $fillable = [
        'translatable_id', 'translatable_type',
        'column_name', 'translation',
        'language'
    ];

    public function translatable()
    {
        return $this->morphTo();
    }

    public function scopeExportQuery($query, $language, $hasTrans)
    {
        return $query
            ->select([
                'WebModelTranslations.id',
                'WebModelTranslations.translatable_id',
                'WebModelTranslations.translatable_type',
                'WebModelTranslations.column_name',
                'WebModelTranslations.translation as english_source',
                'AvailableLanguages.language_code',
                'wmtInner.translation as translation'
            ])
            ->join('AvailableLanguages', DB::raw('1'), '=', DB::raw('1'))
            ->leftJoin('WebModelTranslations as wmtInner', function(JoinClause $join){
                $join
                    ->on('WebModelTranslations.translatable_id', '=', 'wmtInner.translatable_id')
                    ->on('WebModelTranslations.translatable_type', '=', 'wmtInner.translatable_type')
                    ->on('WebModelTranslations.column_name', '=', 'wmtInner.column_name')
                    ->on('wmtInner.language', '=', 'AvailableLanguages.language_code')
                    ->where('wmtInner.deleted_at', '=', '0000-00-00 00:00:00');
            })
            ->where('WebModelTranslations.deleted_at', '=', '0000-00-00 00:00:00')
            ->where('WebModelTranslations.language', '=', 'en');
    }
}