<?php

namespace Hilco\Models;

/**
 * Hilco\Models\StateTax
 *
 * @property integer $id
 * @property string $state
 * @property string $state_name
 * @property float $tax_percentage
 * @property string $effective_date
 * @property string $expiration_date
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereState($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereStateName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereTaxPercentage($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereEffectiveDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereExpirationDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\StateTax inEffect()
 * @mixin \Eloquent
 */
class StateTax extends UuidModel
{
	protected $table = 'StateTaxes';
	public function customers()
	{
		return $this->hasMany(Customer::class,'state','state');
	}
	public function scopeInEffect($query) {
		return $query
			->where(function($query) {
				$query->where('effective_date', '=', '0000-00-00')
					->orWhere('effective_date', '<', date('Y-m-d'));
			})
			->where(function($query) {
				$query->where('expiration_date', '=', '0000-00-00')
					->orWhere('expiration_date', '>', date('Y-m-d'));
			});
	}
}
