<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * M3 price list table matrix
 * @property-read string $PRRF
 */
class OPRMTX extends Model {
    protected $table = "OPRMTX";

    /**
     * @return string
     */
    public function getPriceList() {
        return $this->PRRF;
    }

    /**
     * @param $pricelistConnection , "hilco-pricelist-a" or "hilco-pricelist-b" (fetch from PriceListSchemas table)
     * @param $priceListTable
     * @param $priorityLevel
     * @param $value1
     * @param $value2
     * @param $value3
     * @param $value4
     * @param $value5
     * @return Collection<OPRMTX>
     */
    public static function findPriceListMatrixRecords ($pricelistConnection, $priceListTable, $priorityLevel, $value1, $value2, $value3, $value4, $value5): Collection {
        $priorityLevel = $priorityLevel + 1; // the PC** columns on CROBJC are 0 - 9 but on OPRMTX the PREX values are 1-10
        return
            OPRMTX::on($pricelistConnection)
                ->where('PLTB', "$priceListTable")
                ->where('PREX', "$priorityLevel")
                ->where('OBV1', "$value1")
                ->where('OBV2', "$value2")
                ->where('OBV3', "$value3")
                ->where('OBV4', "$value4")
                ->where('OBV5', "$value5")
                ->get();
    }
}