<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 11/15/17
 * Time: 7:11 PM
 */

namespace Hilco\Models;


class PromotionCustomerCategoryTrigger_CustomerCategory extends WebModel {
    protected $table = 'PromotionCustomerCategoryTrigger_CustomerCategory';
    protected $fillable = ['commit_sequence'];

    public function promotionCustomerCategoryTrigger() {
        return $this->belongsTo(PromotionCustomerCategoryTrigger::class,
                            'promotioncustomercategorytrigger_id', 'id');
    }

    public function customerCategory() {
        return $this->belongsTo(CustomerCategory::class, 'customercategory_id', 'id');
    }

    public function scopeTriggerCustomerCategory($query, $trigger_id, $customerCategory_id) {
        return $query->where(
            [
                'promotioncustomercategorytrigger_id', $trigger_id,
                'customercategory_id', $customerCategory_id
            ]
        );
    }

    use HasCommitSequence;
}