<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\InventoryItem
 *
 * @property mixed $id
 * @property string $plant
 * @property mixed $plant_id
 * @property string $part_no
 * @property mixed $part_id
 * @property string $part_stat
 * @property string $part_src
 * @property string $part_type
 * @property boolean $part_taxable
 * @property boolean $kit_flag
 * @property boolean $on_bom
 * @property boolean $has_bom
 * @property integer $mfg_atp
 * @property float $first_avail_qty
 * @property string $first_avail_dt
 * @property float $max_avail_qty
 * @property string $max_avail_dt
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePlant($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePlantId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartStat($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartSrc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartTaxable($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereKitFlag($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereOnBom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereHasBom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereMfgAtp($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereFirstAvailQty($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereFirstAvailDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereMaxAvailQty($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereMaxAvailDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDeletedAt($value)
 * @mixin \Eloquent
 * @property integer $lot_control
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereLotControl($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDateUploaded($value)
 */
class InventoryItem extends Model
{
    protected $table = 'InventoryItems';
    const CREATED_AT = 'date_created';
    const UPDATED_AT = 'date_modified';
    protected $with = ['partBOMs.compPart.inventoryItems'];

    use \Hilco\SoftDeletes;

    public function partBOMs() {
        return $this->hasMany(PartBOM::class, 'main_part_id', 'part_id');
    }

    public function scopeInPlant(Builder $query, $plant) {
        return $query->where('plant', '=', $plant);
    }

    public function scopeWebFlagIn(Builder $query, $flags) {
        if (!is_array($flags)) $flags = [$flags];
        return $query->whereIn('web_flag', $flags);
    }

    public function scopeInSilo(Builder $query) {
        foreach (b2b()->activePlant() as $plant) {
            $query->orWhere(function ($query) use ($plant) {
                return $query
                    ->where('plant', array_get($plant, 'plant'))
                    ->whereIn('web_flag', config('hilco.inventoryItemWebFlags'))
                    ->where(function ($query) {
                        $query
                            ->where('part_stat', '!=', 'Phase-out')
                            ->orWhere('max_avail_qty', '>', '0')
                        ;
                    })
                ;
            });
        }
        return $query;
    }

    public function scopeIsValid(Builder $query) {
        $query->where('part_stat', '!=', 'Phase-out')->orWhere('max_avail_qty', '>', '0');
    }

    public function getIsValidAttribute() {
        return $this->part_stat != 'Phase-out' || $this->max_avail_qty > 0;
    }

    public function getInStockAttribute() {
        $activePlant = b2b()->activePlant();
        if (!($this->plant == array_get($activePlant, 'plant') && in_array($this->web_flag, config('hilco.inventoryItemWebFlags')))) return false;

        if ($this->kit_flag) {
            foreach ($this->partBOMs as $bom) {
                foreach ($bom->compPart->inventoryItems as $bomInventory) {
                    if ($bomInventory->in_stock) return true;
                }
            }
            return false;
        } else {
            return ($this->net_avail > 0);
        }
    }
}
