<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use LogicException;

/**
 * Class Promotion
 * @package Hilco\Models
 *
 * @method static Builder active()
 */
class PromotionCurrentOrderTrigger extends PromotionTriggerDetails
{
    protected $table = 'PromotionCurrentOrderTriggers';
    protected $fillable = ['minimum_quantity', 'via_web', 'via_cst'];

    public function webGroups() {
        return $this
            ->morphedByMany(WebGroup::class, 'product', 'PromotionCurrentOrderTrigger_Product', 'promotioncurrentordertrigger_id')
            ->withPivot(['excluded'])
        ;
    }

    public function webCategories() {
        return $this
            ->morphedByMany(WebCategory::class, 'product', 'PromotionCurrentOrderTrigger_Product', 'promotioncurrentordertrigger_id')
            ->withPivot(['excluded'])
        ;
    }

    public function webCollections() {
        return $this
            ->morphedByMany(WebCollection::class, 'product', 'PromotionCurrentOrderTrigger_Product', 'promotioncurrentordertrigger_id')
            ->withPivot(['excluded'])
        ;
    }

    public function webFamilies() {
        return $this
            ->morphedByMany(WebFamily::class, 'product', 'PromotionCurrentOrderTrigger_Product', 'promotioncurrentordertrigger_id')
            ->withPivot(['excluded'])
        ;
    }

    public function webParts() {
        return $this
            ->morphedByMany(WebPart::class, 'product', 'PromotionCurrentOrderTrigger_Product', 'promotioncurrentordertrigger_id')
            ->withPivot(['excluded'])
            ;
    }

    public function getRelationForProductTableType($tableType) {
        //
        if($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        }
        else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems) {
        // TODO: Implement isTriggered() method.

        return true;
        //TODO: come back to this later
//        $webCartBuilder = WebCart::where([
//            ['webuser_id', ($soldToCustomer->webUser->id)],
//            ['quantity', '>=', ($this->minimum_quantity)]
//        ])
//        ;
////        dd($webCartBuilder);
//
//        $webPartQuantities = array();
//        foreach($webCartItems as $webCartItem) {
//            $part = $webCartItem->webPart->part;
//            $webPartQuantities[$part->id] += $webCartItem->quantity;
//        }
//
//        $webGroupsInTrigger = $this->webGroups;
//        $webCategoriesInTrigger = $this->webCategories;
//        $webCollectionsInTrigger = $this->webCollections;
//        $webFamiliesInTrigger = $this->webFamilies;
//        $webPartsInTrigger = $this->webParts;
//
//        foreach($webGroupsInTrigger as $webGroup) {
//            foreach($webCartItems as $webCartItem) {
//            }
//        }
    }
}
