@if($edit)
    <div class="mceNonEditable component-container" data-component-key="productCarousel" data-banner-title="{{ $bannerTitle }}">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('app.product_carousel')</h4>
        <p>@lang('app.display_a_ribbon_of_product_hierarchy_elements')</p>
        <div data-banner-id="{{ $bannerId }}" class="carousel-container">
            <div class="row products-container">
                @foreach ($products as $index => $product)
                    <div data-product-index="{{$index}}"
                         data-product-webasset-url="{{ array_get($product, 'productWebAssetUrl') }}"
                         data-product-webasset-id="{{ array_get($product, 'productWebAssetId') }}"
                         data-product-type="{{ array_get($product, 'productType') }}"
                         data-product-id="{{ array_get($product, 'productId') }}"
                         data-product-title="{{ array_get($product, 'productTitle') }}"
                         class="col-md-3 product-container">
                        <div class="product-box" style="margin: 5px; padding: 5px; border: 1px solid black;">
                            <img class="center-block img-responsive product-thumbnail" src="{{ strlen(array_get($product, 'productWebAssetUrl', '')) > 0 ? array_get($product, 'productWebAssetUrl') : webAssetUrl(['width' => 150, 'height' => 150]) }}" alt="">
                            <div class="product-title"> {{ array_get($product, 'productTitle') }}</div>
                            <div class="row">
                                <div class="col-sm-4"><a class="move-left-product-button btn btn-info" href="#">&lt;</a></div>
                                <div class="col-sm-4"><a class="delete-product-button btn btn-danger btn-block" href="#">@lang('app.delete')</a></div>
                                <div class="col-sm-4"><a class="move-right-product-button btn btn-info" href="#">&gt;</a></div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="row">
                <div class="col-md-4 col-md-offset-4">
                    <div>
                        @lang('app.banner_title_colon')
                        <div style="display: inline;" class="banner-title">{{ $bannerTitle }}</div>
                    </div>
                    <a href="#" class="btn btn-primary add-product-button">@lang('app.add_product')</a>
                    <a href="#" class="btn btn-primary set-title-button">@lang('app.set_banner_title')</a>
                </div>
            </div>

        </div>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('productCarousel', {
            menuText: '@lang('app.product_carousel')',
            bladeTemplate: 'hilco::components.productCarousel',
            init: function (body) {
                $(body).on('click', 'a.add-product-button', function () {
                    var carousel = $(this).closest('.carousel-container');
                    var lastProduct = $(carousel).find('div.product-container').last();
                    var newProductIndex = lastProduct.data('product-index') + 1;
                    var newProduct = lastProduct.clone().attr('data-product-index', newProductIndex);
                    newProduct.find('[data-product-index]').each(function () {
                        $(this).attr('data-product-index', newProductIndex);
                    }).find('img').attr('src', '');
                    $(carousel).find('.products-container').append(newProduct);
                });
                $(body).on('click', 'a.delete-product-button', function () {
                    var product = $(this).closest('.product-container');
                    var productCount = $(this).closest('.carousel-container').find('.product-container').length;
                    if (productCount == 1) {
                        alert('@lang('app.you_cannot_delete_the_last_product')');
                        return;
                    }

                    $(product).remove();
                    return false;
                }).on('click', 'a.move-left-product-button', function () {
                   var product = $(this).closest('.product-container');
                   var prev = product.prev();
                   product.insertBefore(prev);
                    return false;
                }).on('click', 'a.move-right-product-button', function () {
                    var product = $(this).closest('.product-container');
                    var next = product.next();
                    product.insertAfter(next);
                    return false;
                });
                $(body).on('click', '.set-title-button', function () {
                    var component = $(this).closest('.component-container');
                    var data = {
                        title: $(component).data('banner-title'),
                    };

                    win = tinymce.activeEditor.windowManager.open({
                        title: 'Set Banner Title',
                        data: data,
                        body: [
                            {
                                name: 'title',
                                type: 'textbox',
                                label: 'Title',
                            },
                        ],
                        onSubmit: function (e) {
                            data = tinymce.extend(data, e.data);
                            component
                                .data('banner-title', data.title)
                                .attr('data-banner-title', data.title)
                            ;
                            component.find('.banner-title').text(data.title);
                        },
                    });
                }).on('click', '.product-box', function () {
                    var product = $(this).closest('.product-container');
                    var data = {
                        product_type: $(product).data('product-type'),
                        product_id: $(product).data('product-id'),
                    };

                    win = tinymce.activeEditor.windowManager.open({
                        title: '@lang('app.configure_product')',
                        data: data,
                        body: [
                            {
                                name: 'product_search',
                                type: 'textbox',
                                label: '@lang('app.product')',
                                id: 'product_search',
                            },
                            {
                                name: 'product_type',
                                type: 'textbox',
                                visible: false,
                                id: 'product_type',
                            },
                            {
                                name: 'product_id',
                                type: 'textbox',
                                visible: false,
                                id: 'product_id',
                            },
                            {
                                name: 'product_title',
                                type: 'textbox',
                                visible: false,
                                id: 'product_title',
                            },
                        ],
                        onSubmit: function (e) {
                            data = tinymce.extend(data, e.data);
                            product
                                .data('product-type', data.product_type)
                                .data('product-id', data.product_id)
                                .data('product-title', data.product_title)
                                .attr('data-product-type', data.product_type)
                                .attr('data-product-id', data.product_id)
                                .attr('data-product-title', data.product_title)
                            ;
                            product.find('.product-title').text(data.product_title);
                            $.getJSON(
                                '{{ route('webAsset.search') }}',
                                {
                                    type: data.product_type,
                                    id: data.product_id
                                },
                                function (webAssetInfo) {
                                    product
                                        .data('product-webasset-url', webAssetInfo.url)
                                        .data('product-webasset-id', webAssetInfo.id)
                                        .attr('data-product-webasset-url', webAssetInfo.url)
                                        .attr('data-product-webasset-id', webAssetInfo.id)
                                    ;
                                    product.find('.product-thumbnail').attr('src', webAssetInfo.url);
                                }
                            );
                        },
                        onPostRender: function () {
                            _win = this;
                            $('#product_search').autocomplete({
                                hint: false,
                                debug: true,
                                appendTo: $('body'),
                                minLength: 2,
                                autoselect: true,
                            }, [
                                {
                                    name: 'products',
                                    source: function (query, callback) {
                                        $.getJSON('/search/productUrl', {
                                            search: query,
                                        }, function (data) {
                                            callback(data);
                                        });
                                    },
                                    displayKey: function (suggestion) {
                                        return suggestion.name;
                                    },
                                    templates: {
                                        suggestion: function (suggestion) {
                                            return suggestion.name + ' - ' + suggestion.styled_type;
                                        }
                                    }
                                }
                            ]).on('autocomplete:selected', function (event, suggestion, dataset) {
                                // $('#customerAlias').val(suggestion.id).closest('form').submit();
                                _win.find('#product_type').value(suggestion.type);
                                _win.find('#product_id').value(suggestion.id);
                                _win.find('#product_title').value(suggestion.name);
                            });
                        }
                    });
                });
            },
            serialize: function (componentNode) {
                var data = {
                    bannerTitle: $(componentNode).data('banner-title'),
                    products: [],
                };
                $(componentNode).find('.product-container').each(function () {
                    data.products.push({
                        productType: $(this).data('product-type'),
                        productId: $(this).data('product-id'),
                        productTitle: $(this).data('product-title'),
                        productWebAssetUrl: $(this).data('product-webasset-url'),
                        productWebAssetId: $(this).data('product-webasset-id'),
                    });
                });
                return data;
            },
        });
    </script>
@endif

@if($view)
    <div class="row container center-block">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{ $bannerTitle or ''}}</h3>
                </div>
                <div class="panel-body" style="height: 240px">
                    <div id="products-carousel" class="owl-carousel owl-theme">
                        @foreach (b2b()->retrieveProductModels($products) as $productModel)
                            <div class="products-carousel-item" style="display: none;">
                                <a href="{{ $productModel->slugUrl() }}" class="">
                                    <div class="image" style="min-height: 100px; padding-top: 15px">
                                        <img src="{{ $productModel->primaryImage(325, 125) }}"
                                             class="img img-responsive center-block" style="max-height: 150px">
                                    </div>
                                    <div class="caption text-center">
                                        <h5>{{ $productModel->name }}</h5>
                                    </div>
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function () {
            var productsCarousel = $('#products-carousel');
            productsCarousel.on({
                'initialized.owl.carousel': function () {
                    productsCarousel.find('.products-carousel-item').show();
                }
            }).owlCarousel({
                autoplay: true,
                autoplayTimeout: 3500,
                autoplayHoverPause: true,
                @if(count($products) > 4)
                loop: true,
                @endif
                responsive: {
                    0: {
                        items: 1,
                    },
                    320: {
                        items: 1
                    },
                    480: {
                        items: @if(auth()->user()) 2 @else 2 @endif,
                    },
                    768: {
                        items: @if(auth()->user()) 3 @else 3 @endif,
                    },
                    992: {
                        items: @if(auth()->user()) 3 @else 3 @endif,
                    },
                    1440: {
                        items: @if(auth()->user()) 4 @else 4 @endif,
                    },
                },
            });
        });
    </script>
@endif
