@if($edit)
    <div class="mceNonEditable component-container" data-component-key="bannerCarousel">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.banner_carousel')</h4>
        <p>@lang('hilco::app.display_banners_across_the_entire_width_of_the_page_that_rotate')</p>
        <div data-banner-id="{{ $bannerId }}" class="banner-container">
            <div class="row slides-container">
                @foreach ($slides as $slideId => $slide)
                    <div data-slide-id="{{$slideId}}" data-link-type="{{ Arr::get($slide, 'link.type') }}" data-link-target="{{ Arr::get($slide, 'link.target') }}" data-web-asset-id="{{ $slide['webAssetId'] }}" data-img-alttag="@if(isset($slide['alttag']))  {{ $slide['alttag'] }} @endif" class="col-md-3 slide-container">
                        <div style="margin: 5px; padding: 5px; border: 1px solid black;">
                            <img class="center-block img-responsive slide-thumbnail" src="{{ webAssetUrl($slide['webAssetId']) }}" alt="@if(isset($slide['alttag']))  {{ $slide['alttag'] }} @endif">
                            @lang('hilco::app.destination_colon') <a href="#" class="slide-url">{!! strlen(webLinkTitle(Arr::get($slide, 'link', []))) ? webLinkTitle($slide['link']) : '<em>'.trans('hilco::app.none').'</em>' !!}</a><br>
                            @lang('hilco::app.alternate_tag') <a href="#" class="slide-alttag">@if(isset($slide['alttag']) && trim($slide['alttag']) != "") {{ $slide['alttag'] }} @else None  @endif</a><br>
                            <a class="delete-slide-button btn btn-danger" href="#">@lang('hilco::app.delete_slide')</a>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="row">
                <div class="col-md-4 col-md-offset-4">
                    <a href="#" class="btn btn-primary add-slide-button">@lang('hilco::app.add_slide')</a>
                </div>
            </div>

        </div>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('bannerCarousel', {
            menuText: '@lang('hilco::app.banner_carousel')',
            bladeTemplate: 'hilco::components.bannerCarousel',
            init: function (body) {
                $(body).on('click', 'a.add-slide-button', function() {
                    var banner = $(this).closest('.banner-container');
                    var lastSlide = $(banner).find('div.slide-container').last();
                    var newSlideId = lastSlide.data('slide-id') + 1;
                    var newSlide = lastSlide.clone().attr('data-slide-id', newSlideId);
                    newSlide.find('[data-slide-id]').each(function () {
                        $(this).attr('data-slide-id', newSlideId);
                    }).find('img').attr('src', '');
                    $(banner).find('.slides-container').append(newSlide);
                });
                $(body).on('click', 'a.delete-slide-button', function () {
                    var slide = $(this).closest('.slide-container');
                    var slideCount = $(this).closest('.banner-container').find('.slide-container').length;
                    if (slideCount == 1) {
                        alert('@lang('hilco::app.you_cannot_delete_the_last_slide')');
                        return;
                    }

                    $(slide).remove();
                });
                $(body).on('click', '.slide-thumbnail', function () {
                    var slide = $(this).closest('.slide-container');
                    assets.finder({
                        successFunction: function (data) {
                            var alt;
                            if(data.alttag != null && data.alttag != ""){
                                alt = data.alttag;
                            }else if(data.name != null && data.name != ""){
                                alt = data.name;
                            }else{
                                alt = 'None'
                            }

                            $(slide).attr('data-web-asset-id', data.id).find('.slide-thumbnail').attr('src', data.urls.thumbnailByHeight);
                            if(alt != 'None') {
                                $(slide).attr('data-web-asset-id', data.id).find('.slide-thumbnail').attr('alt', alt);
                                $(slide).attr('data-img-alttag', alt);
                            }
                            $(slide).attr('data-web-asset-id', data.id).find('.slide-alttag').text(alt);
                        }
                    });
                });
                $(body).on('click', '.slide-url', function () {
                    var slide = $(this).closest('.slide-container');
                    assets.link({
                        successFunction: function (link) {
                            $(slide)
                                .attr('data-link-type', link.link_type)
                                .attr('data-link-target', link.target)
                                .find('.slide-url').text(link.description);
                            ;
                        }
                    });
                });
                $(body).on('click', '.slide-alttag', function () {
                    var slide = $(this).closest('.slide-container');
                    assets.description({
                        successFunction: function (data) {
                            if(data.alttag != null && data.alttag != ""){
                                $(slide).attr('data-img-alttag', data.alttag);
                                $(slide).find('.slide-alttag').text(data.alttag);
                                $(slide).attr('data-web-asset-id', data.id).find('.slide-thumbnail').attr('alt', data.alttag);
                            }
                        }
                    });
                });
            },
            serialize: function (componentNode) {
                var data = {
                    slides: [],
                };
                $(componentNode).find('.slide-container').each(function () {
                    data.slides.push({
                        webAssetId: $(this).data('web-asset-id'),
                        alttag: $(this).data('img-alttag'),
                        link: {
                            type: $(this).data('link-type'),
                            target: $(this).data('link-target'),
                        }
                    });
                });
                return data;
            },
        });
    </script>
@endif

@if($view && b2b()->allowBannerCarousel($lpModel))
    @set('bannerId', str_random(8))
    <div id="banner-carousel-{{$bannerId}}" class="owl-carousel owl-theme">
        @foreach($slides as $slide)
            <div>
                @if(Arr::get($slide, 'link')) <a href="{{ webLinkUrl($slide['link']) }}"> @endif
                    <img src="{{ webAssetUrl($slide['webAssetId']) }}" alt="@if(isset($slide['alttag']))  {{ $slide['alttag'] }} @endif" />
                @if(Arr::get($slide, 'link')) </a> @endif
            </div>
        @endforeach
    </div>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#banner-carousel-{{$bannerId}}').owlCarousel({
                center: true,
                items: 1,
                @if(count($slides) > 1)
                    loop: true,
                @endif
                autoplay: true,
                autoplayTimeout: {{ isset($bannerTimeout) ? $bannerTimeout : '3500' }},
                autoplayHoverPause: true,
                dots: true,
            });
        });
    </script>
@endif