<?php

use Hilco\Models\WebAsset;
use Hilco\Models\WebLandingPage;

if (! function_exists('webAssetUrl')) {
    function webAssetUrl($options) {
        return WebAsset::urlHelper($options);
    }
}

if (! function_exists('webLinkUrl')) {
    function webLinkUrl($options) {
        switch (array_get($options, 'type', 'url')) {
            case 'url':
                return array_get($options, 'target', '');
            case 'webLandingPage':
                return route('landingpage.slug', [array_get($options, 'target')]);
            case 'webAsset':
                return WebAsset::urlHelper(['id' => $options['target'], 'download' => true]);
        }
    }
}

if (! function_exists('webLinkTitle')) {
    function webLinkTitle($options) {
        $target = array_get($options, 'target', '');
        switch (array_get($options, 'type', 'url')) {
            case 'url':
                return $target;
            case 'webLandingPage':
                $webLandingPage = WebLandingPage::whereSlug($target)->first();
                return $webLandingPage ? $webLandingPage->name : '';
            case 'webAsset':
                $webAsset = WebAsset::find($target);
                return $webAsset ? $webAsset->name : '';
        }
    }
}

//if (! function_exists('assetImage')) {
//    /**
//     * Return Image Path.
//     *
//     * @param  string  $path
//     * @return string
//     */
//    function assetImage($path) {
//        $assets = Storage::disk('assets');
//        if ($assets->has($path)) {
//            return $assets->url($path);
//        } else {
//            return asset('images/nopic.png');
//        }
//    }
//}
//
//
//if (! function_exists('partUrl')) {
//    function assetUrl($prefix, $key, $width = false, $height = false) {
//        $api = config('hilco.assets.url', false);
//        if ($api) {
//            $url = "$api/$prefix/$key";
//            if ($width) $url .= "/$width";
//            if ($height) $url .= "/height";
//            return $url;
//        }
//        $diskName = config('hilco.assets.disk', false);
//        if ($diskName) {
//            $disk = Storage::disk($diskName);
//            if ($disk->has("$prefix/$key")) {
//                return $disk->url("$prefix/$key");
//            }
//        }
//        return null;
//    }
//}