@if($edit)
    <div class="mceNonEditable component-container" data-component-key="assetLink" style="display: inline-block; width: 250px; margin: 5px;"
         data-web-asset-id="{{ $webAssetId }}"
         data-link-type="{{ $link['type'] }}"
         data-link-target="{{ $link['target'] }}"
         data-link-caption="{{ $caption }}"
    >
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>Asset Link with Thumbnail</h4>
        <img src="{{ webAssetUrl(['id' => $webAssetId, 'size' => 'thumbnail']) }}" style="min-width: 80px; min-height: 80px;" class="img-responsive center-block asset-link-thumbnail">
        Destination: <a href="#" class="asset-link-url text-center">{!! strlen(webLinkTitle($link)) ? webLinkTitle($link) : '<em>None</em>'  !!} </a><br>
        Caption: <a href="#" class="asset-link-caption text-center">{!! strlen($caption) ? $caption : '<em>None</em>'  !!} </a>
        {{--<a class="edit-asset-link-button btn btn-primary" href="#">Edit Thumbnail</a>--}}
        {{--<a class="edit-asset-link-url-button btn btn-primary" href="#">Edit Destination</a>--}}
        {{--<a class="edit-asset-link-caption-button btn btn-primary" href="#">Edit Caption</a>--}}
    </div>
@endif

@if($script)
    <script type="text/javascript">
        function setAssetLinkImage(component, asset) {
            component.find('.asset-link-thumbnail').attr('src', asset.urls.thumbnail);
            component.attr('data-web-asset-id', asset.id);
        }
        function setAssetLinkLink(component, description, linkType, linkTarget) {
            component.find('.asset-link-url').text(description);
            component.attr('data-link-type', linkType);
            component.attr('data-link-target', linkTarget);
        }
        function setAssetLinkCaption(component, caption) {
            component.find('.asset-link-caption').text(caption);
            component.attr('data-link-caption', caption);
        }

        registerComponent('assetLink', {
            inline: true,
            menuText: 'Asset Link with Thumbnail',
            bladeTemplate: 'hilco::components.assetLink',
            init: function (body) {
                $(body).on('click', '.asset-link-thumbnail', function() {
                    var button = this;
                    assets.finder({
                        successFunction: function(data) {
                            setAssetLinkImage($(button).closest('.component-container'), data);
                        }
                    });
                });
                $(body).on('click', '.asset-link-url', function() {
                    var button = this;
                    assets.link({
                        successFunction: function(data) {
                            setAssetLinkLink($(button).closest('.component-container'), data.description, data.link_type, data.target);
                        }
                    });
                });
                $(body).on('click', '.asset-link-caption', function() {
                    var container = $(this).closest('.component-container');
                    var caption = prompt('Please enter a caption', container.data('link-caption'));
                    setAssetLinkCaption(container, caption);
                });
            },
            serialize: function (componentNode) {
                return {
                    webAssetId: $(componentNode).data('web-asset-id'),
                    link: {
                        type: $(componentNode).data('link-type'),
                        target: $(componentNode).data('link-target'),
                    },
                    caption: $(componentNode).data('link-caption'),
                };
            },
            insert: function (component) {
                assets.finder({
                    successFunction: function(data) {
                        setAssetLinkImage(component, data);
                        setAssetLinkLink(component, data.asset_category + '/' + data.asset_key, 'webAsset', data.id);
                        setAssetLinkCaption(component, data.name);
                    }
                });
            }
        });
    </script>
@endif

@if($view)
<div style="display: inline-block; width: 150px; min-height: 150px;">
    <a href="{{ webLinkUrl($link) }}" class="thumbnail">
        <img src="{{ webAssetUrl(['id' => $webAssetId, 'size' => 'thumbnail']) }}">
        <div class="text-center">{{ $caption }}</div>
    </a>
</div>
@endif
