<?php

namespace Hilco\Models;


/**
 * Hilco\Models\OrderAttnLine
 *
 * @property mixed $id
 * @property-read mixed $id_string
 * @property mixed $salesorder_id
 * @property string $date_created
 * @property string status
 * @property string customer_payment_profile_id
 * @property string transaction_id
 * @property string authorization_code
 * @property string last_four_digits
 * @property string expiration_date
 * @property string future_authorization
 * @property string authorized_amount
 * @property string captured_amount
 * @property string date_authorized
 * @property string date_captured
 * @property string origin
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property mixed source_creditcardauthorization_id
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereSalesorderId($value)
 * @mixin \Eloquent
 */
class CreditCardAuthorization extends UuidModel
{
    protected $table = 'CreditCardAuthorizations';

    public function salesOrder() {
        return $this->belongsTo(Order::class, 'warehouse_id');
    }
}
