<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 2/3/20
 * Time: 11:31 AM
 */

namespace Hilco\Models;

use Arr;

/**
 * @property string delivery_method_code
 * @property integer deliverymethod_id
 * @property string delivery_term_code
 * @property integer deliveryterm_id
 * @property integer def_delivery_priority
 * @property string division
 * @property integer division_id
 * @property boolean priority_modifiable
 * @property DeliveryMethod deliveryMethod
 * @property DeliveryTerm deliveryTerm
 * @property Division divisionRelation
 */
class DeliveryMethodTerm extends WebModel {
    protected $table = "DeliveryMethod_DeliveryTerm";
    protected $fillable = [
        'delivery_method_code', 'deliverymethod_id',
        'delivery_term_code', 'deliveryterm_id',
        'division', 'division_id',
        'def_delivery_priority', 'priority_modifiable',
    ];

    public function deliveryMethod() {
        return $this->belongsTo(DeliveryMethod::class, 'deliverymethod_id', 'id');
    }

    public function deliveryTerm() {
        return $this->belongsTo(DeliveryTerm::class, 'deliveryterm_id', 'id');
    }

    public function divisionRelation() {
        return $this->belongsTo(Division::class, 'division_id', 'id');
    }

    public function scopeCodes($query, $codes) {
        return $query->whereIn('delivery_method_code', $codes);
    }

    public static function createMethodTerm (array $createData) {
        DeliveryMethodTerm::withTrashed()->where('deliverymethod_id', '=', $createData['deliverymethod_id'])->where('deliveryterm_id', '=', $createData['deliveryterm_id']);
        if (Arr::has($createData, 'deliverymethod_id') && !Arr::has($createData, 'delivery_method_code')) {
            $createData['delivery_method_code'] = DeliveryMethod::find($createData['deliverymethod_id'])?->delivery_method_code;
        }
        if (Arr::has($createData, 'deliveryterm_id') && !Arr::has($createData, 'delivery_term_code')) {
            $createData['delivery_term_code'] = DeliveryTerm::find($createData['deliveryterm_id'])?->delivery_term_code;
        }
        if (Arr::has($createData, 'division_id') && !Arr::has($createData, 'division')) {
            $createData['division'] = Division::find($createData['division_id'])?->division;
        }
        $methodTerm = DeliveryMethodTerm::withTrashed()->where(
            'deliverymethod_id', '=', $createData['deliverymethod_id']
        )->where(
            'deliveryterm_id', '=', $createData['deliveryterm_id']
        )->where(
            'division_id', '=', $createData['division_id']
        )->first();
        if ($methodTerm && $methodTerm->isTrashed()) {
            $methodTerm->restore()->update($createData);
        } else {
            $methodTerm = DeliveryMethodTerm::create($createData);
        }
        return $methodTerm;
    }

    public static function delivery($method, $term, $priority){
        return DeliveryMethodTerm::where("deliverymethod_id", '=', $method)->where('deliveryterm_id', '=', $term)
            ->where('def_delivery_priority', '=', $priority)->where('deleted_at', '=', '0000-00-00 00:00:00')->first();
    }
}