<?php

namespace Hilco\Models;

class WebLink_WebSilo extends WebModel {

	protected $table = "WebLink_WebSilo";
    protected $fillable = ['weblink_id', 'websilo_id', 'plant_id', 'is_visible', 'display_name', 'de_name', 'en_name',  'link', 'type'];
    protected $with = ['webLink'];

    public function plant() {
        return $this->belongsTo(Plant::class, 'plant_id', 'id');
    }

    public function webLink() {
        return $this->belongsTo(WebLink::class, 'weblink_id', 'id');
    }

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function getUrl(){
        if ($this->type == 'landing_page') {
            $url = route('landingpage.slug', [$this->link]);
        } else if ($this->type == 'asset') {
            $url = config('hilco.assets.url');
            $url .= '/' . $this->link;
        } else {
            $url = url($this->link);
        }

        return $url;
    }

    use HasTranslations;

    public function getNameAttribute() {
        $name = $this->getTranslatedName(false, $this->display_name);
        if (strlen($name)) return $name;

        return array_get($this, 'webLink.name');
    }

    public function getEnNameAttribute() {
        $name = $this->getTranslatedName('en', $this->display_name);
        if (strlen($name)) return $name;

        return array_get($this, 'webLink.en_name');
    }

    public function getDeNameAttribute() {
        $name = $this->getTranslatedName('de', $this->display_name);
        if (strlen($name)) return $name;

        return array_get($this, 'webLink.de_name');
    }

    public function getTypeAttribute() {
        if (strlen($this->attributes['type'])) return $this->attributes['type'];

        return array_get($this, 'webLink.type');
    }

    public function getLinkAttribute() {
        if (strlen($this->attributes['link'])) return $this->attributes['link'];

        return array_get($this, 'webLink.link');
    }
}
