<?php

namespace Hilco\Models;

use DB;
use Hilco\Models\SelectsRelatedCount;
use Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WebAttribute extends Model
{
	use \Hilco\SoftDeletes;

	const CREATED_AT = 'date_created';
	const UPDATED_AT = 'date_modified';

	protected $table = 'WebAttributes';
	protected $fillable = ['attribute_name', 'en_name', 'de_name', 'fr_name'];

	public function webParts() {
		return $this->belongsToMany(WebPart::class, 'WebAttribute_WebPart', 'webattribute_id', 'webpart_id')->withPivot(['attribute_value']);
	}

	public function webFamilies() {
		return $this->belongsToMany(WebFamily::class, 'WebAttribute_WebFamily', 'webattribute_id', 'webfamily_id');
	}

	public function values() {
		return $this->hasMany(WebAttribute_WebPart::class, 'webattribute_id', 'id');
	}

	public function getValuesInCategoryAttribute() {
		return $this->webParts->sortBy('pivot.attribute_value')->pluck('pivot.attribute_value', 'pivot.attribute_value');
	}

	public function scopeInCollection($query, $webCollection) {
		$webCollectionId = ($webCollection instanceof WebCollection) ? $webCollection->id : $webCollection;
		return $query->whereHas('webFamilies', function ($query) use ($webCollectionId) {
			return $query->inCollection($webCollectionId);
		});
	}

	public function scopeInCategory($query, $webCategory) {
		$webCategoryId = ($webCategory instanceof WebCategory) ? $webCategory->id : $webCategory;
		return $query->whereHas('webFamilies', function ($query) use ($webCategoryId) {
			return $query->inCategory($webCategoryId);
		});
	}

	public function scopeInGroup($query, $webGroup) {
		$webGroupId = ($webGroup instanceof WebGroup) ? $webGroup->id : $webGroup;
		return $query->whereHas('webFamilies', function ($query) use ($webGroupId) {
			return $query->inGroup($webGroupId);
		});
	}

	public static function in($model) {
		if ($model instanceof WebGroup) {return self::inGroup($model);}
		else if ($model instanceof WebCategory) return self::inCategory($model);
		else if ($model instanceof WebCollection) return self::inCollection($model);
	}

//
    public function getAttributeNameAttribute() {
        $translatedName = $this->getTranslation('name');
        if (!strlen($translatedName)) $translatedName = $this->attributes['attribute_name'];
        return $translatedName;
    }
//
//    public function getEnAttributeNameAttribute() {
//	    return $this->getTranslation('attribute_name', 'en');
//    }
//
//    public function getDeAttributeNameAttribute() {
//        return $this->getTranslation('attribute_name', 'de');
//    }
//
//    public function setEnAttributeNameAttribute($name) {
//	    $this->setTranslation('en', 'attribute_name', $name);
//    }
//
//    public function setDeAttributeNameAttribute($name) {
//        $this->setTranslation('de', 'attribute_name', $name);
//    }

	use RevisionableTrait, HasTranslations;
//	use RevisionableTrait;
}
