<?php

namespace Hilco\Models;
use Hilco\SoftDeletes;

class CustomerDiscountGroup extends UuidModel {
	protected $table = 'CustomerDiscountGroups';
    const UPDATED_AT = 'date_modified';
    use SoftDeletes;

    public function customers() {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function itemDiscounts() {
        return $this
            ->hasMany(ItemDiscount::class, 'sales_code', 'discount_group_code')
            ->where('sales_type', '=', 'Customer Disc. Group')
        ;
    }
}
