<?php

namespace Hilco\Models;

/**
 * Class PromotionHubspotSubTrigger
 * @package Hilco\Models
 * @property string $subscriptionid
 * @property bool $check_legacy_rewards
 */
class PromotionHubspotSubTrigger extends PromotionTriggerDetails {
    protected $table = "PromotionHubspotSubTriggers";
    protected $fillable = ['subscriptionid', 'check_legacy_rewards'];
    protected $casts = ['check_legacy_rewards' => 'boolean'];

    public function isTriggered(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        if ($this->check_legacy_rewards && isset($soldToCustomer->legacyRewardsCustomer)) {
            return true;
        }

        return $soldToCustomer->hasHubSpotMarketingContacts();
    }

    public function postTriggerOperation($soldToCustomer){}
}