<?php
namespace Hilco\Models;

use DB;

class DatafeedField extends WebModel {
    protected $table = 'DatafeedFields';

    public function bindingRules() {
        return $this->hasMany(DatafeedFieldBindingRule::class, 'datafeedfield_id', 'id')->orderBy("order");
    }

    public function getBindingRule($binding_type) {
        return $this->bindingRules()->where('binding_type', $binding_type)->first();
    }
    public function hasBinding($binding_type) {
        $bindingRule = $this->getBindingRule($binding_type);
        return $bindingRule != null;
    }

    public function getCalculatedOrderAttribute(){
        return $this->defaultOrder;
    }
    
    public function getCalculatedOrderIndexAttribute(){
        return $this->calculatedOrder - 1;
    }

    public function getSequenceNumberAttribute(){
        return 1;
    }

    public function getDatafeedfieldIdAttribute(){
        return $this->id;
    }
    
    public function getEnabledAttribute(){
        return $this->defaultEnabled;
    }

    public function getOverrideNameAttribute(){
        return '';
    }

}
