<?php

namespace Hilco\Models;

use Illuminate\Support\Collection;

trait SupportsDataTablesTrait {
    public static function toDataTableArrays(Collection $collection = null) {
        if (is_null($collection)) $collection = self::all();
        $data = [];
        foreach ($collection as $item) {
            $data[] = $item->toDataTableArray();
        }
        return $data;
    }

    public static function fromDataTableArrays($arrays) {
        $responses = [];
        foreach ($arrays as $id=>$data) {
            $responses[] = self::find($id)->fromDataTableArray($data);
        }
        return $responses;
    }

    public function toDataTableArray() {
        return $this->toArray();
    }
}