<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Model;

class WebPart_Solr extends Model
{
    protected $table = 'WebPart_Solr';
    protected $fillable = ['webPart_id', 'hash', 'visible', 'lastAction'];

    const UPDATED_AT = 'date_modified';
    const CREATED_AT = 'date_created';

    use \Hilco\SoftDeletes;

    public function item() {
        return $this->belongsTo(WebPart::class, 'webPart_id', 'id');
    }

    public function scopeByDeletedRecords($query) {
        return $query
            ->whereRaw("(lastAction IN ('Added', 'Updated') OR visible != 0)")
            ->whereDoesntHave('item', function ($query) {
                $query
                    ->has('webFamilies.webCollections.webCategories.webGroups')
                    ->whereHas('part', function ($query) {
                        $query->whereHas('inventoryItems', function ($query) {
                            $query->isValid();
                        });
                    });
            });
    }
}