<?php

namespace Hilco\Models;

use Debugbar;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Venturecraft\Revisionable\RevisionableTrait;

class WebSiloOverride extends WebModel  {
	protected $table = "WebSiloOverrides";
	protected $fillable = ['websilo_id', 'overrideable_type', 'overrideable_id', 'name', 'is_visible', 'primary_webasset_id'];
	protected $casts = [
	    'is_visible' => 'boolean'
	];

	public function primaryImage() {
	    return $this->belongsTo(WebAsset::class, 'primary_webasset_id', 'id');
    }

    public function webSilo() {
	    return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function overrideable() {
	    return $this->morphTo();
    }
}
