<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;
use Hilco\SoftDeletes;


class CustomerAttribute extends Model
{
    protected $table = 'CustomerAttributes';
    const CREATED_AT = 'date_created';
    const UPDATED_AT = 'date_modified';

    protected $fillable = ['part_no','part_id', 'attribute_name', 'attribute_value', 'list_id', 'deleted_at'];

    use SoftDeletes;

    public function list()
    {
        return $this->belongsTo(CustomerAttributeList::class);
    }
}