<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:35 AM
 */

namespace Hilco\Listeners;


use App;
use Hilco\Events\UserWasRegistered;
use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Support\Facades\Mail;


/**
 * Sends an email to the customer to provide information about their new account.
 *
 * Class EmailNewUserConfirmation
 * @package Hilco\Listeners
 */
class EmailNewUserConfirmation
{

    public function construct() {

    }

    public function handle(UserWasRegistered $event)
    {
        $customerModel = $event->webUser->customer;

        if (isset($customerModel)) {
            $countryCode = $customerModel->address_country;
            if($countryCode == 'DE' || $countryCode == 'AT'){
                $lang = 'de';
            }else if($countryCode == 'FR'){
                $lang = 'fr';
            }else{
                $lang = 'en';
            }
        } else {
            $lang = 'de';
        }

        $oldLocale = App::getLocale();
        App::setLocale($lang);
        Mail::send(
            $event->selfCreated ? 'hilco::emails.newUserConfirmation' : 'hilco::emails.newUserInvitation',
            [
                'webUser' => $event->webUser,
                'temporaryPassword' => $event->temporaryPassword,
                'url' => config('hilco.b2b.url')
            ],
            function ($mail) use ($event) {
                $mail->to($event->webUser->email);

                foreach (config('hilco.emailDestinations.newUserConfirmation.to', []) as $to) {
                    if (strlen($to)) $mail->to($to);
                }

                foreach (config('hilco.emailDestinations.newUserConfirmation.bcc', []) as $bcc) {
                    if (strlen($bcc)) $mail->bcc($bcc);
                }

                $mail->subject(trans('email.newUserConfirmationSubject'));
            }
        );
        App::setLocale($oldLocale);

        $event->webUser->needs_password_reset = 1;
        $event->webUser->save();
    }
}