<?php

namespace Hilco\Models;

use Auth;
use DB;
use Storage;
use Image as Image2;

/**
 * Hilco\Models\Product
 *
 * @property mixed $id
 * @property string $part_no
 * @property string $part_desc
 * @property string $part_upc
 * @property string $upc_w_check
 * @property string $sls_uom
 * @property string $weight_lbs
 * @property string $vol_ci
 * @property boolean $private_lbl
 * @property string $cat_item
 * @property boolean $web_part
 * @property string $incept_dt
 * @property string $pf_prod_mgr
 * @property string $prod_fam_no
 * @property string $product_family
 * @property string $pf_group
 * @property string $fin_rpt_sum
 * @property string $fin_rpt_sub
 * @property string $product_category
 * @property string $product_category_grp
 * @property string $product_category_summ
 * @property string $web_part_desc
 * @property string $web_part_family
 * @property float $list_price
 * @property string $price_group
 * @property string $prod_cat
 * @property string $prod_cat_grp
 * @property string $prod_cat_summ
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Hilco\Models\WebPart $details
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\ProductAttributeValues[] $attributes
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\PriceList[] $prices
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Cart[] $cart_items
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\InventoryItem[] $inventory_items
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePartNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePartDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePartUpc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereUpcWCheck($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereSlsUom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWeightLbs($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereVolCi($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePrivateLbl($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereCatItem($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWebPart($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereInceptDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePfProdMgr($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdFamNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductFamily($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePfGroup($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereFinRptSum($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereFinRptSub($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductCategory($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductCategoryGrp($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductCategorySumm($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWebPartDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereWebFamily($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereListPrice($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePriceGroup($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdCat($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdCatGrp($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProdCatSumm($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $product_family_no
 * @property mixed $productfamily_id
 * @property string $rx_dose_form
 * @property string $rx_ndc
 * @property float $rx_packsize
 * @property string $rx_strength
 * @property string $vat_code
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductFamilyNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereProductfamilyId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxDoseForm($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxNdc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxPacksize($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereRxStrength($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereVatCode($value)
 * @property string $pointman_web_part_desc
 * @property string $pointman_web_part_family
 * @property string $date_uploaded
 * @property-read mixed $web_part_name
 * @property-read mixed $name
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePointmanWebPartDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part wherePointmanWebPartFamily($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part distinctProductManagers()
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Part managedBy($product_manager)
 */
class Part extends WebModel
{
	protected $table = 'Parts';
//	protected $appends = ['web_part_name', 'web_part_family'];
//	protected $with = ['details'];
	protected $guarded = ['id'];
	protected $getterMutators = [
//		'id' => 'bin2hex',
		'productfamily_id' => 'bin2hex',
	];
	protected $setterMutators = [
		'productfamily_id' => 'hex2bin',
	];

    const IN_STOCK = 'inStock';
    const OUT_OF_STOCK = 'outOfStock';
    const DELAYED = 'delayed';
    const UNKNOWN = 'unknown';

	public function webPart() {
		return $this->hasOne(WebPart::class, 'part_number', 'part_no');
	}
	public function VATTax(){
		return  $this->belongsTo(VATTax::class, 'vat_code', 'vat_code')
				->where(function($query){
					$query->where(function($query){
						return $query->where('effective_date','<=', date('Y-m-d',time()))
							->where('expiration_date','>=', date('Y-m-d',time()));
					})
						->orWhere('expiration_date', '000-00-00');
				});
	}
	public function details() {
		return $this->webPart();
	}

	public function getWebPartNameAttribute() {
		return is_null($this->details) ? null : $this->details->web_part_name;
	}

	public function getNameAttribute() {
		return is_null($this->web_part_name) ? $this->part_desc : $this->web_part_name;
	}

	public function getWebFamilyAttribute() {
		return $this->details->webFamily;
	}

//	public function attributes()
//	{
//		return $this->belongsToMany(ProductAttributeValues::class, 'Part_PartAttributeValue', 'part_id', 'partattributevalue_id');
//	}

    public function customerPrices() {
        $customerPriceList = WebUser::activePriceList();
        $siloPriceList = WebSilo::currentPriceList();
        return $this
            ->hasMany(PriceList::class, 'part_id', 'id')
            ->whereIn('price_list', [$customerPriceList, $siloPriceList])
            ->where('currency', WebUser::activeCurrency())
            ;
    }

	public function prices() {
	    return $this->hasMany(PriceList::class, 'part_id');
	}

	public function getPricesArrayAttribute() {
	    $prices = [];
        $this->customerPrices->each(function ($item) use (&$prices) {
            $prices[$item->price_list][$item->quantity_level] = collect($item->toArray())->sortByDesc('quantity_level');
        });
        if (array_has($prices, WebUser::activePriceList())) return $prices[WebUser::activePriceList()];
        return array_get($prices, WebSilo::currentPriceList());
    }

	public function getCustomerPrice($quantity = 1) {
	    $price = collect($this->prices_array)
			->filter(function ($item, $key) use ($quantity) {
            return $item['quantity_level'] <= $quantity;
        })
			->sortByDesc('quantity_level')
			->first();

	    $preDiscountPrice = array_get($price, 'price');

        $totalDiscountPercent = $this->getCustomerDiscount();
        $totalDiscountAmount = 0;
        if ($totalDiscountPercent > 0) {
            $totalDiscountAmount = round($preDiscountPrice * ($totalDiscountPercent / 100), 2);
        }

        $postDiscountPrice = $preDiscountPrice - $totalDiscountAmount;

	    return $postDiscountPrice;
    }

    public function getCustomerDiscount() {
        $authUser = Auth::user();
        $soldToCustomer = $authUser->active_customer;
        $productFamilyId = $this->productfamily_id;
        $partId = $this->id;
        $customerDiscounts = $soldToCustomer->discounts->filter(function ($item) use ($productFamilyId, $partId) {
            return (
                ($item->productfamily_id && $item->productfamily_id == $productFamilyId)
                || ($item->part_id && $item->part_id == $partId)
            );
        });

        $totalDiscountPercent = 0;
        if ($customerDiscounts !== null) {
            foreach ($customerDiscounts as $customerDiscount) {
                $totalDiscountPercent += $customerDiscount->disc_val;
            }
        }

        return $totalDiscountPercent;
    }

    public function getCustomerPriceAttribute() {
        return $this->getCustomerPrice();
    }

//	public function cart_items()
//	{
//		return $this->hasMany(Cart::class, 'product_id');
//	}

	public function inventoryItems() {
        return $this->hasMany(InventoryItem::class, 'part_id', 'id');
	}

//	public function inventory_items()
//	{
//		return $this->hasMany(InventoryItem::class, 'part_id', 'id');
//	}

	public function plainvilleInventory()
	{
		return $this->hasMany(InventoryItem::class, 'part_id')->where('plant','PLAINVILLE');
	}

//	public function getImageLink($width = null, $height = null)
//	{
//		$name = ($width ? $width : 'a') . 'x' . ($height ? $height : 'a');
//		$extension_arr = array('.jpg', '.png');
//		$src =  url('img/logo_hilco.png'); //TODO: change to "NoImage" picture
//		if($this->part_no) {
//			foreach ( $extension_arr as $extension ) {
//				if(Storage::disk('product')->exists($this->part_no . $extension)){
//					if ((Image2::make(public_path('img/products/' . $this->part_no . $extension))->width() > $width || Image2::make(public_path('img/products/' . $this->part_no . $extension))->height() > $height)
//					    && (!Storage::disk('product')->exists($this->part_no . '_' . $name . $extension))) {
//						Image2::make(public_path('img/products/' . $this->part_no . $extension))->fit($width, $height)->save(public_path('img/products/' . $this->part_no . '_' . $name . $extension));
//						$src = url('img/products/'.  $this->part_no . '_' . $name . $extension);
//					} else {
//						$src = url('img/products/'.  $this->part_no . $extension);
//					}
//					break;
//				}
//			}
//		}
//
//		return $src;
//	}

	public function productFamily()	{
		return $this->belongsTo(ProductFamilies::class, 'productfamily_id', 'id');
	}

	public static function getPartsBySummary($id)
	{
		$category_arr = ProductCategory::whereHas('categoryGroup', function($categoryGroup) use ($id){
							$categoryGroup->whereHas('categorySummary', function($categorySummary) use ($id) {
								$categorySummary->where('id', '=', ($id));
							});
						})->get();
		if ($category_arr) {
			$items = array();
			foreach ($category_arr as $category) {
				$family = ProductCategory::getProductFamilies($category->id)->toArray();
				$collection = Part::where('web_part', 1)->whereIn('productfamily_id', $family)->get();
				if (!$collection->isEmpty() && $collection->count() >= 2) {
					$merge_arr = $collection->random( 2 )->toArray();
					$items = array_merge($items, $merge_arr);
				}
			}
		}
		return $items;
	}

	/**
	 * @param \Illuminate\Database\Query\Builder $query
	 * @return mixed
     */
	public function scopeDistinctProductManagers($query) {
		return $query->distinct()->select('pf_prod_mgr');
	}

	public function scopeManagedBy($query, $product_manager) {
		return $query->where('pf_prod_mgr', $product_manager);
	}

	public function scopeWebParts($query) {
		return $query->where('web_part', 1);
	}
	
	public function scopeIsNotRX($query){
		return $query->where(function($query){
			return $query->where('rx_ndc','=',"")->orWhere('rx_ndc','=',"N/A");
		});
	}

    public function getInStockAttribute() {
        $inStock = false;
        foreach ($this->inventoryItems as $inventoryItem) {
            if ($inventoryItem->in_stock) $inStock = true;
        }
        return $inStock;
    }

	public function getStockStatusAttribute() {
        /* OH GOD WHY IS THIS HARD CODED PLZ HELP */
        $activeCountry = WebUser::activeCountry();
        if (is_null($activeCountry) || $activeCountry == 'US') {
            foreach ($this->inventoryItems as $inventoryItem) {
                if ($inventoryItem->plant == 'PLAINVILLE' && $inventoryItem->in_stock) return self::IN_STOCK;
            }
            return self::OUT_OF_STOCK;
        } else if ($activeCountry == 'CA') {
            $inPlainville = false;
            $inMontreal = false;
            foreach ($this->inventoryItems as $inventoryItem) {
                if ($inventoryItem->plant == 'PLAINVILLE' && $inventoryItem->in_stock) $inPlainville = true;
                if ($inventoryItem->plant == 'MONTREAL' && $inventoryItem->in_stock) $inMontreal = true;
            }

            if (WebUser::activeShippingAddress()->def_ship_from == 'MONTREAL') {
                if ($inMontreal) return self::IN_STOCK;
                else if ($inPlainville) return self::DELAYED;
                else return self::OUT_OF_STOCK;
            } else {
                if ($inPlainville) return self::IN_STOCK;
                else if ($inMontreal) return self::DELAYED;
                else return self::OUT_OF_STOCK;
            }
        }
        return self::UNKNOWN;
    }

}

