<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 11/15/17
 * Time: 10:54 AM
 */

namespace Hilco\Models;


class PromotionItemDiscountAction_Product extends WebModel {
    protected $table = 'PromotionItemDiscountAction_Product';
    protected $fillable = ['excluded', 'commit_sequence'];

    public function itemDiscountAction() {
        return $this->belongsTo(PromotionItemDiscountAction::class,
                            'promotionitemdiscountaction_id', 'id');
    }

    public function scopeActionProduct($query, $action_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotionitemdiscountaction_id' => $action_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;
}