<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 4/2/19
 * Time: 10:19 AM
 */

namespace Hilco\Models;

use Flynsarmy\DbBladeCompiler\Facades\DbView;
use Illuminate\Database\Eloquent\Model;
use Hilco\Models\WebModelTranslation;

/**
 * Trait HasModelTranslations
 * @package Hilco\Models
 */
trait HasModelTranslations {

    protected $queuedTranslations = [];

    public static function bootHasModelTranslations() {
        static::created (function (Model $translatableModel) {
            foreach ($translatableModel->queuedTranslations as $translationInfo) {
                $translatableModel->setTranslation($translationInfo['language'], $translationInfo['column_name'], $translationInfo['translation']);
            }
            $translatableModel->queuedTranslations = [];
        });
    }

    public function translations() {
        return $this->morphMany(WebModelTranslation::class, 'translatable');
    }

    public function getTranslation ($columnName, $language = false, $default = false) {
        if ($language === false) $language = b2b()->activeLanguage();
        if ($default === false) $default = array_get($this->attributes, $columnName, '');
        $modelTranslation = $this->translations()->where('language', $language)->where('column_name', $columnName)->first();
        if (!isset($modelTranslation) && $language != 'en') {
            return '';
        }
        return array_get($modelTranslation, "translation", $default);
    }

    public function getTranslationForEdit ($columnName, $language = false, $default = false) {
        if ($language === false) $language = b2b()->activeLanguage();
        if ($default === false) {
            $default = $columnName . "_for_edit";
        }
        $modelTranslation = $this->translations()->where('language', $language)->where('column_name', $columnName)->first();
        if (!isset($modelTranslation) && $language != 'en') {
            return '';
        }
        return isset($modelTranslation) ? $modelTranslation->translation_for_edit : $this->$default;
    }

    public function deleteTranslation($columnName, $language){
        $this->translations->where('language', $language)->where('column_name', $columnName)->first()->delete();
    }

    public function setTranslation($language, $columnName, $translation, $type = null) {
        if (!$this->exists) {
            $this->queuedTranslations[] = [
                'language' => $language,
                'column_name' => $columnName,
                'translation' => $translation
            ];
        } else {
            $modelTranslation = $this->translations()->withTrashed()->where('language', $language)->where('column_name', $columnName)->first();
            if(!empty($modelTranslation)){
                $modelTranslation->restore();
            }
            if(is_null($type)){
                $type = lcfirst(class_basename($this));
            }
            $this->translations()
                ->updateOrCreate(
                    [
                        'language' => $language,
                        'column_name' => $columnName
                    ],
                    [
                        'translatable_type' => $type,
                        'translation' => $translation
                    ]
                )
            ;
        }
    }

    protected static $morphMap = [
        'feedBackSubject'   => FeedbackSubject::class,
        'feedBackType'      => FeedbackType::class,
        'webAttribute'      => WebAttribute::class,
        'webLink'           => WebLink::class,
        'webLinkCategory'   => WebLinkCategory::class,
        'webPart'           => WebPart::class,
        'webFamily'         => WebFamily::class,
        'webCategory'       => WebCategory::class,
        'webCollection'     => WebCollection::class,
        'webGroup'          => WebGroup::class,
        'webSilo'           => WebSilo::class,
        'webSiloOverride'   => WebSiloOverride::class,
    ];

    /**
     * Get the morph mapping of trigger/action types to their actual class models
     * @return array
     */
    public static function getMorphMap() {
        return self::$morphMap;
    }
}