<?php

use Hilco\Models\Customer;
use Hilco\Models\CustomerShippingAddress;
use Hilco\Models\PriceListSchema;

abstract class Cart {
    private int $soldToCustomerId;
    private string $soldToCustomerNumber;
    private int $billToCustomerId;
    private string $billToCustomerNumber;
    private int $shipToCustomerId;
    private string $shipToAddressNumber;
    private string $shipToAddressLine1;
    private string $shipToAddressLine2;
    private string $shipToAddressLine3;
    private string $shipToAddressCity;
    private string $shipToAddressState;
    private string $shipToAddressZip;
    private string $shipToAddressCountry;
    private string $defaultShipToFreightAccount;
    private int $defaultDeliveryMethodId;
    private string $defaultDeliveryMethodCode;
    private int $defaultDeliveryTermId;
    private string $defaultDeliveryTermCode;
    private string $shippingPolicy;
    private int $chosenDeliveryMethodId;
    private string $chosenDeliveryMethodCode;
    private int $chosenDeliveryTermId;
    private string $chosenDeliveryTermCode;
    private string $currencyCode;
    private string $defaultPaymentTermsId;
    private float $itemsPriceTotal = 0.0;
    private float $discountedItemsPriceTotal = 0.0;
    private float $shippingPriceTotal = 0.0;
    private float $discountedShippingPriceTotal = 0.0;
    private float $taxPriceTotal = 0.0;
    /**
     * @var array<CartLine>
     */
    private array $cartLines = [];
    /**
     * @var array<CartPromotion>
     */
    private array $appliedCartPromotions = [];

    public function __construct (Customer $soldToCustomer, Customer $billToCustomer, CustomerShippingAddress $shipToCustomer) {
        $this->soldToCustomerId = $soldToCustomer->id;
        $this->soldToCustomerNumber = $soldToCustomer->getCustNo();
        $this->billToCustomerId = $billToCustomer->id;
        $this->billToCustomerNumber = $billToCustomer->getCustNo();
        $this->shipToCustomerId = $shipToCustomer->id;
        $this->shipToAddressNumber = $shipToCustomer->getAddrNo();
        $this->shipToAddressLine1 = $shipToCustomer->getAddrLine1();
        $this->shipToAddressLine2 = $shipToCustomer->getAddrLine2();
        $this->shipToAddressLine3 = $shipToCustomer->getAddrLine3();
        $this->shipToAddressCity = $shipToCustomer->getCity();
        $this->shipToAddressState = $shipToCustomer->getState();
        $this->shipToAddressZip = $shipToCustomer->getZip();
        $this->shipToAddressCountry = $shipToCustomer->getCountry();
        $this->defaultShipToFreightAccount = $shipToCustomer->getDefShipVia();
        $deliveryMethod = $shipToCustomer->deliveryMethod;
        if (isset($deliveryMethod)) {
            $this->defaultDeliveryMethodId = $deliveryMethod->id;
            $this->defaultDeliveryMethodCode = $deliveryMethod->getDeliveryMethodCode();
        } else {
            $this->defaultDeliveryMethodId = 0;
            $this->defaultDeliveryMethodCode = null;
        }
        $deliveryTerm = $shipToCustomer->deliveryTerm;
        if (isset($deliveryTerm)) {
            $this->defaultDeliveryTermId = $deliveryTerm->id;
            $this->defaultDeliveryTermCode = $deliveryTerm->getDeliveryTermCode();
        } else {
            $this->defaultDeliveryTermId = 0;
            $this->defaultDeliveryTermCode = null;
        }
        $webSilo = $soldToCustomer->webSilo;
        $soldToSegment = $soldToCustomer->customerSegment;
        if (is_null($webSilo->getDefaultShipPolicy())) {
            $this->shippingPolicy = $soldToSegment->getDefaultShippingPolicyCode();
        } else {
            $this->shippingPolicy = $webSilo->getDefaultShipPolicy();
        }
        $this->currencyCode = $billToCustomer->getCurrency();
        $billToSegment = $billToCustomer->customerSegment;
        $this->defaultPaymentTermsId = $billToSegment->paymentTerm->id;
        $this->cartLines = [];
        $this->appliedCartPromotions = [];
    }

    /**
     * @param array $lines
     * @return void
     */
    public function setCartLines (array $lines) {
        $this->cartLines = $lines;
    }
}